/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.HistoryWidget;
import genj.app.Workbench;
import genj.app.WorkbenchListener;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.swing.Action2;
import genj.util.swing.ToolbarWidget;
import genj.view.ActionProvider;
import genj.view.View;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import spin.Spin;

class Toolbar
extends ToolbarWidget
implements WorkbenchListener,
ActionProvider {
    private static final Resources RES = Resources.get(Toolbar.class);
    private static final Registry REGISTRY = Registry.get(Toolbar.class);
    private static final Logger LOG = Logger.getLogger("genj.app");
    private Workbench workbench;
    private HistoryWidget history;
    private List<Action> actions = new CopyOnWriteArrayList<Action>();
    private GedcomListener callback = new GedcomListenerAdapter(){

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            Toolbar.this.setup(gedcom);
        }
    };
    private Gedcom gedcom;

    Toolbar(Workbench workbench) {
        this.workbench = workbench;
        workbench.addWorkbenchListener(this);
        this.history = new HistoryWidget(workbench);
        this.setFloatable(false);
        this.setup(null);
        this.setVisible(REGISTRY.get("visible", true));
    }

    private void remove(Action action) {
        if (this.gedcom != null && action instanceof GedcomListener) {
            this.gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)action));
        }
        if (action instanceof WorkbenchListener) {
            this.workbench.removeWorkbenchListener((WorkbenchListener)((Object)action));
        }
        this.actions.remove(action);
    }

    private void setup(Gedcom gedcom) {
        if (this.gedcom != null) {
            this.gedcom.removeGedcomListener(this.callback);
        }
        for (Action object : this.actions) {
            this.remove(object);
        }
        this.removeAll();
        this.gedcom = gedcom;
        this.add(new Workbench.ActionNew(this.workbench));
        this.add(new Workbench.ActionOpen(this.workbench));
        Workbench workbench = this.workbench;
        workbench.getClass();
        this.add(new Workbench.ActionSave(workbench, false));
        if (gedcom != null) {
            Action2.Group group = new Action2.Group("ignore");
            this.addSeparator();
            for (ActionProvider actionProvider : this.workbench.getProviders(ActionProvider.class)) {
                group.clear();
                actionProvider.createActions(this.workbench.getContext(), ActionProvider.Purpose.TOOLBAR, group);
                Iterator<Action2> iterator = group.iterator();
                while (iterator.hasNext()) {
                    Action2 action2 = iterator.next();
                    if (action2 instanceof Action2.Group) {
                        LOG.warning("ActionProvider " + actionProvider + " returned a group for toolbar");
                        continue;
                    }
                    if (action2 instanceof ActionProvider.SeparatorAction) {
                        this.addSeparator();
                        continue;
                    }
                    this.add(action2);
                }
            }
        }
        if (this.gedcom != null) {
            this.gedcom.addGedcomListener(this.callback);
        }
        this.add(this.history);
    }

    public JButton add(Action action) {
        this.actions.add(action);
        action.putValue("MnemonicKey", null);
        action.putValue("Name", null);
        if (this.gedcom != null && action instanceof GedcomListener) {
            this.gedcom.addGedcomListener((GedcomListener)Spin.over((Object)action));
        }
        if (action instanceof WorkbenchListener) {
            this.workbench.addWorkbenchListener((WorkbenchListener)((Object)action));
        }
        return super.add(action);
    }

    public void commitRequested(Workbench workbench) {
    }

    public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
        this.setup(null);
    }

    public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
        this.setup(gedcom);
    }

    public void processStarted(Workbench workbench, Trackable trackable) {
    }

    public void processStopped(Workbench workbench, Trackable trackable) {
    }

    public void selectionChanged(Workbench workbench, Context context, boolean bl) {
        this.setup(context.getGedcom());
    }

    public void viewClosed(Workbench workbench, View view) {
    }

    public void viewOpened(Workbench workbench, View view) {
    }

    public void workbenchClosing(Workbench workbench) {
    }

    public void createActions(Context context, ActionProvider.Purpose purpose, Action2.Group group) {
        if (purpose == ActionProvider.Purpose.MENU) {
            ActionProvider.ViewActionGroup viewActionGroup = new ActionProvider.ViewActionGroup();
            viewActionGroup.add(new Visible());
            group.add(viewActionGroup);
        }
    }

    private class Visible
    extends Action2 {
        protected Visible() {
            this.setText(RES, "toolbar");
            this.setSelected(REGISTRY.get("visible", true));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !REGISTRY.get("visible", true);
            REGISTRY.put("visible", bl);
            Toolbar.this.setVisible(bl);
        }
    }
}

