/*
 * Decompiled with CFR 0.152.
 */
package genj.chart;

import genj.chart.IndexedSeries;
import genj.chart.XYSeries;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class Chart
extends JPanel {
    private void init(String string, Plot plot, boolean bl) {
        this.setLayout(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, plot, bl));
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
        this.add((Component)chartPanel, "Center");
    }

    public Chart(String string, String string2, String string3, IndexedSeries[] indexedSeriesArray, NumberFormat numberFormat, boolean bl) {
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setNumberFormatOverride(numberFormat);
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = bl ? new StackedXYAreaRenderer2() : new XYAreaRenderer();
        XYPlot xYPlot = new XYPlot((XYDataset)IndexedSeries.asTableXYDataset(indexedSeriesArray), (ValueAxis)numberAxis, (ValueAxis)numberAxis2, (XYItemRenderer)stackedXYAreaRenderer2);
        this.init(string, (Plot)xYPlot, true);
    }

    public Chart(String string, String string2, String string3, XYSeries[] xYSeriesArray, NumberFormat numberFormat, boolean bl) {
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setNumberFormatOverride(numberFormat);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(bl ? 3 : 2);
        XYPlot xYPlot = new XYPlot(XYSeries.toXYDataset(xYSeriesArray), (ValueAxis)numberAxis, (ValueAxis)numberAxis2, (XYItemRenderer)standardXYItemRenderer);
        this.init(string, (Plot)xYPlot, true);
    }

    public Chart(String string, IndexedSeries indexedSeries, String[] stringArray, boolean bl) {
        PiePlot piePlot = new PiePlot(IndexedSeries.asPieDataset(indexedSeries, stringArray));
        piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1}"));
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 10.0));
        this.init(string, (Plot)piePlot, bl);
    }

    public Chart(String string, String string2, IndexedSeries[] indexedSeriesArray, String[] stringArray, NumberFormat numberFormat, boolean bl, boolean bl2) {
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setNumberFormatOverride(numberFormat);
        Object object = bl ? new StackedBarRenderer() : new BarRenderer();
        object.setSeriesPaint(0, (Paint)Color.BLUE);
        object.setSeriesPaint(1, (Paint)Color.RED);
        CategoryPlot categoryPlot = new CategoryPlot(IndexedSeries.asCategoryDataset(indexedSeriesArray, stringArray), categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)object);
        categoryPlot.setOrientation(!bl2 ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        this.init(string, (Plot)categoryPlot, true);
    }
}

