/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.TagPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PathTreeWidget
extends JScrollPane {
    private List<Listener> listeners = new ArrayList<Listener>();
    private Grammar grammar = Grammar.V55;
    private JTree tree;
    private Model model = new Model();

    public PathTreeWidget() {
        Callback callback = new Callback();
        this.tree = new JTree(this.model);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new Renderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(callback);
        this.tree.addTreeWillExpandListener(callback);
        this.setMinimumSize(new Dimension(160, 160));
        this.setPreferredSize(new Dimension(160, 160));
        this.getViewport().setView(this.tree);
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void fireSelectionChanged(TagPath tagPath, boolean bl) {
        Listener[] listenerArray = this.listeners.toArray(new Listener[this.listeners.size()]);
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].handleSelection(tagPath, bl);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setPaths(TagPath[] tagPathArray, TagPath[] tagPathArray2) {
        Object[] objectArray;
        this.model.setPaths(tagPathArray, tagPathArray2);
        for (TagPath tagPath : tagPathArray) {
            objectArray = new Object[]{this.model, new TagPath(tagPath.get(0))};
            this.tree.expandPath(new TreePath(objectArray));
        }
        for (TagPath tagPath : tagPathArray2) {
            objectArray = new Object[tagPath.length()];
            objectArray[0] = this.model;
            for (int i = 1; i < tagPath.length(); ++i) {
                objectArray[i] = new TagPath(tagPath, i);
            }
            this.tree.expandPath(new TreePath(objectArray));
        }
    }

    public void setSelected(TagPath tagPath, boolean bl) {
        this.model.setSelected(tagPath, bl);
    }

    public TagPath[] getSelection() {
        return this.model.getSelection().toArray(new TagPath[0]);
    }

    private class Callback
    extends MouseAdapter
    implements TreeWillExpandListener {
        private Callback() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = PathTreeWidget.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            PathTreeWidget.this.model.toggleSelection((TagPath)treePath.getLastPathComponent());
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            if (treeExpansionEvent.getPath().getPathCount() < 3) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }
    }

    public static interface Listener {
        public void handleSelection(TagPath var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    implements TreeModel {
        private Set<TagPath> paths = new HashSet<TagPath>();
        private Set<TagPath> selection = new HashSet<TagPath>();
        private Map<TagPath, TagPath[]> path2childen = new HashMap<TagPath, TagPath[]>();
        private List<TreeModelListener> tmlisteners = new CopyOnWriteArrayList<TreeModelListener>();

        private Model() {
        }

        public void setPaths(TagPath[] tagPathArray, TagPath[] tagPathArray2) {
            this.selection = new HashSet<TagPath>(Arrays.asList(tagPathArray2));
            this.paths = new HashSet<TagPath>();
            this.paths.addAll(Arrays.asList(tagPathArray));
            this.paths.addAll(Arrays.asList(tagPathArray2));
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this});
            for (TreeModelListener treeModelListener : this.tmlisteners) {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        private void setSelected(TagPath tagPath, boolean bl) {
            if (!this.paths.contains(tagPath)) {
                throw new IllegalArgumentException("path not a choice");
            }
            if (bl) {
                this.selection.add(tagPath);
            } else {
                this.selection.remove(tagPath);
            }
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this});
            for (TreeModelListener treeModelListener : this.tmlisteners) {
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
            PathTreeWidget.this.fireSelectionChanged(tagPath, bl);
        }

        private void toggleSelection(TagPath tagPath) {
            if (this.selection.contains(tagPath)) {
                this.setSelected(tagPath, false);
            } else {
                this.setSelected(tagPath, true);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.tmlisteners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.tmlisteners.remove(treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            return this.getChildren(object)[n];
        }

        @Override
        public int getChildCount(Object object) {
            return this.getChildren(object).length;
        }

        private TagPath[] getChildren(Object object) {
            TagPath[] tagPathArray = this.path2childen.get(object);
            if (tagPathArray == null) {
                tagPathArray = object == this ? this.getChildrenOfRoot() : this.getChildrenOfNode((TagPath)object);
            }
            return tagPathArray;
        }

        private TagPath[] getChildrenOfNode(TagPath tagPath) {
            ArrayList<TagPath> arrayList = new ArrayList<TagPath>(8);
            for (TagPath tagPath2 : this.paths) {
                if (tagPath2.length() <= tagPath.length() || !tagPath2.startsWith(tagPath)) continue;
                this.add(new TagPath(tagPath2, tagPath.length() + 1), arrayList);
            }
            for (TagPath tagPath2 : this.selection) {
                if (tagPath2.length() <= tagPath.length() || !tagPath2.startsWith(tagPath)) continue;
                this.add(new TagPath(tagPath2, tagPath.length() + 1), arrayList);
            }
            return TagPath.toArray(arrayList);
        }

        private TagPath[] getChildrenOfRoot() {
            ArrayList<TagPath> arrayList = new ArrayList<TagPath>(8);
            for (TagPath tagPath : this.paths) {
                this.add(new TagPath(tagPath, 1), arrayList);
            }
            for (TagPath tagPath : this.selection) {
                this.add(new TagPath(tagPath, 1), arrayList);
            }
            return TagPath.toArray(arrayList);
        }

        private void add(TagPath tagPath, List<TagPath> list) {
            if (!list.contains(tagPath)) {
                list.add(tagPath);
            }
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            return 0;
        }

        @Override
        public Object getRoot() {
            return this;
        }

        @Override
        public boolean isLeaf(Object object) {
            return this.getChildren(object).length == 0;
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public Collection<TagPath> getSelection() {
            return this.selection;
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private JPanel panel = new JPanel();
        private JCheckBox checkbox = new JCheckBox();

        private Renderer() {
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.checkbox, "West");
            this.panel.add((Component)this, "Center");
            this.checkbox.setOpaque(false);
            this.panel.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof TagPath) {
                TagPath tagPath = (TagPath)object;
                this.setText(tagPath.getLast() + " (" + Gedcom.getName(tagPath.getLast()) + ")");
                this.setIcon(PathTreeWidget.this.grammar.getMeta(tagPath).getImage());
                this.checkbox.setSelected(PathTreeWidget.this.model.getSelection().contains(object));
                this.panel.invalidate();
            }
            return this.panel;
        }
    }
}

