/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.BasicEditor;
import genj.edit.EditView;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.ChangeSupport;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.view.ContextProvider;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPanel
extends JPanel
implements ContextProvider {
    private static final Resources RES = Resources.get(BeanPanel.class);
    private static final Registry REGISTRY = Registry.get(BeanPanel.class);
    private static Map<String, NestedBlockLayout> DESCRIPTORCACHE = new HashMap<String, NestedBlockLayout>();
    private Property root;
    protected ChangeSupport changeSupport = new ChangeSupport(this);
    private List<PropertyBean> beans = new ArrayList<PropertyBean>(32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NestedBlockLayout getLayout(String string) {
        NestedBlockLayout nestedBlockLayout;
        block7: {
            nestedBlockLayout = DESCRIPTORCACHE.get(string);
            if (nestedBlockLayout != null) {
                return nestedBlockLayout.copy();
            }
            if (DESCRIPTORCACHE.containsKey(string)) {
                return null;
            }
            try {
                InputStream inputStream = BeanPanel.class.getResourceAsStream(string);
                if (inputStream == null) break block7;
                try {
                    nestedBlockLayout = new NestedBlockLayout(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {
                EditView.LOG.log(Level.WARNING, "cannot read descriptor " + string + " (" + throwable.getMessage() + ")");
            }
        }
        DESCRIPTORCACHE.put(string, nestedBlockLayout);
        return nestedBlockLayout != null ? nestedBlockLayout.copy() : null;
    }

    private static NestedBlockLayout getLayout(MetaProperty metaProperty) {
        if (Entity.class.isAssignableFrom(metaProperty.getType())) {
            return BeanPanel.getLayout("descriptors/entities/" + metaProperty.getTag() + ".xml");
        }
        String string = "descriptors/properties/" + metaProperty.getTag() + ".xml";
        NestedBlockLayout nestedBlockLayout = BeanPanel.getLayout(string);
        if (nestedBlockLayout != null) {
            return nestedBlockLayout;
        }
        for (Class<? extends Property> clazz = metaProperty.getType(); clazz != null; clazz = clazz.getSuperclass()) {
            nestedBlockLayout = BeanPanel.getLayout("descriptors/properties/" + clazz.getSimpleName() + ".xml");
            if (nestedBlockLayout == null) continue;
            return nestedBlockLayout;
        }
        return null;
    }

    public BeanPanel() {
        this.setFocusTraversalPolicy(new FocusPolicy());
        this.setFocusCycleRoot(true);
    }

    @Override
    public ViewContext getContext() {
        return this.root != null ? new ViewContext(this.root) : null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public boolean isCommittable() {
        for (PropertyBean propertyBean : this.getBeans()) {
            if (propertyBean.isCommittable()) continue;
            return false;
        }
        return true;
    }

    public void commit() throws GedcomException {
        for (PropertyBean propertyBean : this.beans) {
            if (!propertyBean.hasChanged()) continue;
            propertyBean.commit();
        }
        this.changeSupport.setChanged(false);
    }

    public List<PropertyBean> getBeans() {
        return this.beans;
    }

    public List<? extends Action> getActions() {
        ArrayList<? extends Action> arrayList = new ArrayList<Action>();
        for (PropertyBean propertyBean : this.beans) {
            arrayList.addAll(propertyBean.getActions());
        }
        return arrayList;
    }

    @Override
    public void requestFocus() {
        if (this.beans.isEmpty()) {
            return;
        }
        this.beans.get(0).requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.beans.isEmpty()) {
            return false;
        }
        this.beans.get(0).requestFocusInWindow();
        return true;
    }

    public void setRoot(Property property) {
        ArrayList<PropertyBean> arrayList = new ArrayList<PropertyBean>(this.beans);
        this.beans.clear();
        for (PropertyBean object : arrayList) {
            object.removeChangeListener(this.changeSupport);
            object.getParent().remove(object);
            PropertyBean.recycle(object);
        }
        this.removeAll();
        this.root = property;
        if (property != null) {
            HashSet hashSet = new HashSet();
            NestedBlockLayout nestedBlockLayout = BeanPanel.getLayout(property.getMetaProperty());
            if (nestedBlockLayout != null) {
                this.parse(property, property, nestedBlockLayout, hashSet);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void parse(Property property, Property property2, NestedBlockLayout nestedBlockLayout, Set<String> set) {
        this.setLayout(nestedBlockLayout);
        for (NestedBlockLayout.Cell cell : nestedBlockLayout.getCells()) {
            JComponent jComponent = this.createComponent(property, property2, cell, set);
            if (jComponent == null) continue;
            this.add((Component)jComponent, cell);
        }
    }

    protected JComponent createComponent(Property property, Property property2, NestedBlockLayout.Cell cell, Set<String> set) {
        String string = cell.getElement();
        String string2 = cell.getAttribute("gedcom");
        if (string2 != null & !property2.getGedcom().getGrammar().getVersion().equals(string2)) {
            return null;
        }
        if ("text".equals(string)) {
            return new JLabel(cell.getAttribute("value"));
        }
        if ("fold".equals(string)) {
            String string3;
            String string4 = cell.getAttribute("key");
            if (string4 == null) {
                throw new IllegalArgumentException("fold without key");
            }
            String string5 = RES.getString(string4, false);
            if (string5 == null) {
                string5 = Gedcom.getName(string4);
            }
            NestedBlockLayout.Expander expander = new NestedBlockLayout.Expander(string5, (string3 = cell.getAttribute("indent")) != null ? Integer.parseInt(string3) : 1);
            Registry registry = new Registry(REGISTRY, property.getTag() + '.' + string4);
            expander.setCollapsed(registry.get("folded", "1".equals(cell.getAttribute("collapsed"))));
            expander.addPropertyChangeListener("folded", registry);
            return expander;
        }
        if ("label".equals(string)) {
            String string6 = cell.getAttribute("key");
            if (string6 != null) {
                return new JLabel(RES.getString(string6));
            }
            String string7 = cell.getAttribute("path");
            if (string7 == null) {
                throw new IllegalArgumentException("label without key or path");
            }
            MetaProperty metaProperty = property2.getMetaProperty().getNestedRecursively(new TagPath(string7), false);
            if (Entity.class.isAssignableFrom(metaProperty.getType())) {
                return new JLabel(metaProperty.getName() + ' ' + ((Entity)property).getId(), null, 2);
            }
            return new JLabel(metaProperty.getName(cell.isAttribute("plural")), null, 2);
        }
        if ("bean".equals(string)) {
            TagPath tagPath = new TagPath(cell.getAttribute("path"));
            MetaProperty metaProperty = property2.getMetaProperty().getNestedRecursively(tagPath, false);
            PropertyBean propertyBean = this.createBean(property2, tagPath, cell.getAttribute("type"));
            if (propertyBean == null) {
                return null;
            }
            String string8 = cell.getAttribute("dir");
            if (string8 != null && string8.startsWith("h")) {
                propertyBean.setPreferHorizontal(true);
            }
            if (set != null && property2 == property && tagPath.length() > 1) {
                set.add(tagPath.get(1));
            }
            return propertyBean;
        }
        throw new IllegalArgumentException("Template element " + cell.getElement() + " is unkown");
    }

    private PropertyBean createBean(Property property, TagPath tagPath, String string) {
        Property property2 = property.getProperty(tagPath, false);
        PropertyBean propertyBean = string != null ? PropertyBean.getBean(string) : (property2 != null ? PropertyBean.getBean(property2.getClass()) : PropertyBean.getBean(property.getMetaProperty().getNestedRecursively(tagPath, false).getType("")));
        propertyBean.setContext(property, tagPath, property2, this.beans);
        propertyBean.addChangeListener(this.changeSupport);
        this.beans.add(propertyBean);
        return propertyBean;
    }

    private class PopupBean
    extends PopupWidget
    implements MouseMotionListener,
    MouseListener {
        private PropertyBean wrapped;
        private JPanel content;

        private PopupBean(PropertyBean propertyBean) {
            this.setFocusable(false);
            this.setBorder(null);
            this.wrapped = propertyBean;
            Property property = propertyBean.getProperty();
            this.setToolTipText(property.getPropertyName());
            ImageIcon imageIcon = property.getImage(false);
            if (property.getValue().length() == 0) {
                imageIcon = imageIcon.getGrayedOut();
            }
            this.setIcon(imageIcon);
            this.content = new JPanel(new BorderLayout());
            this.content.setAlignmentX(0.0f);
            this.content.setBorder(new TitledBorder(property.getPropertyName()));
            this.content.addMouseMotionListener(this);
            this.content.addMouseListener(this);
            this.content.add(propertyBean);
            this.content.setFocusCycleRoot(true);
            this.addItem(this.content);
        }

        private ImageIcon getImage(Property property) {
            while (property.getParent() != null && !(property.getParent() instanceof Entity)) {
                property = property.getParent();
            }
            return property.getImage(false);
        }

        public void showPopup() {
            super.showPopup();
            Dimension dimension = BasicEditor.REGISTRY.get("popup." + this.wrapped.getProperty().getTag(), (Dimension)null);
            if (dimension != null) {
                this.setPopupSize(dimension);
            }
            SwingUtilities.getWindowAncestor(this.wrapped).setFocusableWindowState(true);
            this.wrapped.requestFocus();
            this.setIcon(this.wrapped.getProperty().getImage(false));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.content.getCursor() == Cursor.getPredefinedCursor(5)) {
                Dimension dimension = new Dimension(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                BasicEditor.REGISTRY.put("popup." + this.wrapped.getProperty().getTag(), dimension);
                this.setPopupSize(dimension);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getX() > this.content.getWidth() - this.content.getInsets().right && mouseEvent.getY() > this.content.getHeight() - this.content.getInsets().bottom) {
                this.content.setCursor(Cursor.getPredefinedCursor(5));
                return;
            }
            if (mouseEvent.getY() < this.content.getInsets().top) {
                try {
                    this.content.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.content.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.content.getCursor() == Cursor.getPredefinedCursor(12)) {
                this.cancelPopup();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class FocusPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private Hack hack = new Hack();

        private FocusPolicy() {
        }

        protected boolean accept(Component component) {
            return this.hack.accept(component);
        }

        public Component getComponentAfter(Container container, Component component) {
            return BeanPanel.this.beans.isEmpty() ? null : super.getComponentAfter(container, component);
        }

        public Component getComponentBefore(Container container, Component component) {
            return BeanPanel.this.beans.isEmpty() ? null : super.getComponentBefore(container, component);
        }

        public Component getDefaultComponent(Container container) {
            return BeanPanel.this.beans.isEmpty() ? null : super.getDefaultComponent(container);
        }

        private class Hack
        extends LayoutFocusTraversalPolicy {
            private Hack() {
            }

            protected boolean accept(Component component) {
                return super.accept(component);
            }
        }
    }
}

