/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.util.swing.NestedBlockLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateEntity
extends AbstractChange {
    private String etag;
    private JTextField requestID;

    public CreateEntity(Gedcom gedcom, String string) {
        super(gedcom, Gedcom.getEntityImage(string).getOverLayed(imgNew), resources.getString("add", Gedcom.getName(string, false)));
        this.etag = string;
    }

    protected JPanel getDialogContent() {
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><row><text wx=\"1\" wy=\"1\"/></row><row><check/><text/></row></col>"));
        this.requestID = new JTextField(this.gedcom.getNextAvailableID(this.etag), 8);
        this.requestID.setEditable(false);
        final JCheckBox jCheckBox = new JCheckBox(resources.getString("assign_id"));
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateEntity.this.requestID.setEditable(jCheckBox.isSelected());
                if (jCheckBox.isSelected()) {
                    CreateEntity.this.requestID.requestFocusInWindow();
                }
            }
        });
        jPanel.add(this.getConfirmComponent());
        jPanel.add(jCheckBox);
        jPanel.add(this.requestID);
        return jPanel;
    }

    protected String getConfirmMessage() {
        String string = resources.getString("confirm.new", Gedcom.getName(this.etag, false), this.gedcom);
        if (!"INDI".equals(this.etag) || !this.gedcom.getIndis().isEmpty()) {
            string = string + '\n' + resources.getString("confirm.new.unrelated");
        }
        return string;
    }

    protected Context execute(Gedcom gedcom, ActionEvent actionEvent) throws GedcomException {
        String string = null;
        if (this.requestID.isEditable() && gedcom.getEntity(this.etag, string = this.requestID.getText()) != null) {
            throw new GedcomException(resources.getString("assign_id_error", string));
        }
        Entity entity = gedcom.createEntity(this.etag, string);
        entity.addDefaultProperties();
        return new Context(entity);
    }
}

