/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.common.SelectEntityWidget;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.util.WordBuffer;
import genj.util.swing.NestedBlockLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class CreateRelationship
extends AbstractChange {
    protected Registry REGISTRY = Registry.get(CreateRelationship.class);
    private Entity existing;
    private JCheckBox checkID;
    private JTextField requestID;
    protected String targetType;

    public CreateRelationship(String string, Gedcom gedcom, String string2) {
        super(gedcom, Gedcom.getEntityImage(string2), resources.getString("add", string));
        this.targetType = string2;
    }

    protected String getConfirmMessage() {
        WordBuffer wordBuffer = new WordBuffer("\n");
        wordBuffer.append(this.existing == null ? resources.getString("confirm.new", Gedcom.getName(this.targetType, false), this.gedcom) : resources.getString("confirm.use", this.existing.getId(), this.gedcom));
        wordBuffer.append(resources.getString("confirm.new.related", this.getDescription()));
        String string = this.getWarning(this.existing);
        if (string != null) {
            wordBuffer.append("**Note**: " + string);
        }
        return wordBuffer.toString();
    }

    public abstract String getDescription();

    public String getWarning(Entity entity) {
        return null;
    }

    protected JPanel getDialogContent() {
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><row><select wx=\"1\"/></row><row><text wx=\"1\" wy=\"1\"/></row><row><check/><text/></row></col>"));
        final SelectEntityWidget selectEntityWidget = new SelectEntityWidget(this.gedcom, this.targetType, SelectEntityWidget.NEW);
        this.existing = selectEntityWidget.getSelection();
        this.requestID = new JTextField(this.gedcom.getNextAvailableID(this.targetType), 8);
        this.requestID.setEditable(false);
        this.checkID = new JCheckBox(resources.getString("assign_id"));
        this.checkID.getModel().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CreateRelationship.this.requestID.setEditable(CreateRelationship.this.checkID.isSelected());
                if (CreateRelationship.this.checkID.isSelected()) {
                    CreateRelationship.this.requestID.requestFocusInWindow();
                }
            }
        });
        jPanel.add(selectEntityWidget);
        jPanel.add(this.getConfirmComponent());
        jPanel.add(this.checkID);
        jPanel.add(this.requestID);
        selectEntityWidget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateRelationship.this.existing = selectEntityWidget.getSelection();
                if (CreateRelationship.this.existing != null) {
                    CreateRelationship.this.checkID.setSelected(false);
                }
                CreateRelationship.this.checkID.setEnabled(CreateRelationship.this.existing == null);
                CreateRelationship.this.refresh();
            }
        });
        if (!this.targetType.equals("INDI") && !this.targetType.equals("FAM")) {
            selectEntityWidget.setSelection(this.gedcom.getEntity(this.REGISTRY.get("select." + this.gedcom.getName() + "." + this.targetType, (String)null)));
        }
        return jPanel;
    }

    protected final Context execute(Gedcom gedcom, ActionEvent actionEvent) throws GedcomException {
        Object object;
        Entity entity;
        if (this.existing != null) {
            entity = this.existing;
        } else {
            object = null;
            if (this.requestID.isEditable() && gedcom.getEntity(this.targetType, (String)(object = this.requestID.getText())) != null) {
                throw new GedcomException(resources.getString("assign_id_error", object));
            }
            entity = gedcom.createEntity(this.targetType, (String)object);
            entity.addDefaultProperties();
        }
        object = this.change(entity, entity != this.existing);
        this.REGISTRY.put("select." + gedcom.getName() + "." + this.targetType, entity.getId());
        return new Context(((Property)object).getEntity());
    }

    protected abstract Property change(Entity var1, boolean var2) throws GedcomException;
}

