/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.Images;
import genj.edit.actions.AbstractChange;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelProperty
extends AbstractChange {
    private Set<Property> candidates = new HashSet<Property>();

    public DelProperty(Property property) {
        super(property.getGedcom(), Images.imgDel, resources.getString("delete"));
        this.candidates.add(property);
    }

    public DelProperty(List<? extends Property> list) {
        super(list.get(0).getGedcom(), Images.imgDel, resources.getString("delete"));
        this.candidates.addAll(list);
    }

    @Override
    protected String getConfirmMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(resources.getString("confirm.del.props", this.candidates.size()));
        stringBuffer.append("\n");
        int n = 0;
        for (Property property : this.candidates) {
            if (n++ > 16) {
                stringBuffer.append("...");
                break;
            }
            stringBuffer.append(property.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    protected Context execute(Gedcom gedcom, ActionEvent actionEvent) throws GedcomException {
        HashSet<Entity> hashSet = new HashSet<Entity>();
        for (Property property : this.candidates) {
            if (property instanceof PropertyXRef && property.isValid()) {
                hashSet.add(((PropertyXRef)property).getTargetEntity());
                hashSet.add(property.getEntity());
            }
            property.getParent().delProperty(property);
        }
        for (Entity entity : hashSet) {
            if (entity instanceof Indi || entity.isConnected()) continue;
            gedcom.deleteEntity(entity);
        }
        return null;
    }
}

