/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.GridBagHelper;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DialogHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlaceBean
extends PropertyBean {
    private GridBagHelper gh = new GridBagHelper(this);
    private int rows = 0;
    private JCheckBox global = new JCheckBox();
    private Property[] sameChoices = new Property[0];

    public PlaceBean() {
        this.changeSupport.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = PlaceBean.this.getGlobalConfirmMessage();
                PlaceBean.this.global.setVisible(string != null);
                PlaceBean.this.global.setToolTipText(string);
            }
        });
        this.global.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PlaceBean.this.global.isSelected()) {
                    int n = DialogHelper.openDialog(PropertyBean.RESOURCES.getString("choice.global.enable"), 3, PlaceBean.this.getGlobalConfirmMessage(), (Action[])Action2.yesNo(), (Object)PlaceBean.this);
                    PlaceBean.this.global.setSelected(n == 0);
                }
            }
        });
    }

    private String getCommitValue() {
        boolean bl = ((PropertyPlace)this.getProperty()).getFormatAsString().length() > 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getComponentCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChoiceWidget)) continue;
            String string = ((ChoiceWidget)component).getText().trim();
            if (bl) {
                string = string.replaceAll(",", ";");
            }
            if (n2++ > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected void commitImpl(Property property) {
        ((PropertyPlace)property).setValue(this.getCommitValue(), this.global.isSelected());
        this.setPropertyImpl(property);
    }

    public void setPropertyImpl(Property property) {
        int n;
        String string;
        String[] stringArray;
        String[] stringArray2;
        String string2;
        int n2 = this.rows;
        this.rows = 0;
        this.defaultFocus = null;
        Gedcom gedcom = this.getRoot().getGedcom();
        PropertyPlace propertyPlace = (PropertyPlace)property;
        if (propertyPlace == null) {
            this.sameChoices = new Property[0];
            string2 = "";
            stringArray2 = PropertyPlace.getFormat(gedcom);
            stringArray = new String[]{};
            string = gedcom.getPlaceFormat();
        } else {
            this.sameChoices = propertyPlace.getSameChoices();
            string2 = propertyPlace.getValue();
            stringArray2 = propertyPlace.getFormat();
            string = propertyPlace.getFormatAsString();
            stringArray = propertyPlace.getJurisdictions();
        }
        if (string.length() == 0) {
            this.createChoice(null, string2, PropertyPlace.getAllJurisdictions(gedcom, -1, true), string);
        } else {
            for (n = 0; n < Math.max(stringArray2.length, stringArray.length); ++n) {
                this.createChoice(n < stringArray2.length ? stringArray2[n] : "?", n < stringArray.length ? stringArray[n] : "", PropertyPlace.getAllJurisdictions(gedcom, n, true), null);
            }
        }
        this.global.setVisible(false);
        this.global.setSelected(false);
        this.gh.add(this.global, 2, this.rows);
        this.gh.addFiller(1, ++this.rows);
        for (n = 0; n < n2; ++n) {
            this.remove(0);
        }
    }

    private void createChoice(String string, String string2, String[] stringArray, String string3) {
        ++this.rows;
        if (string != null) {
            this.gh.add(new JLabel(string, 4), 0, this.rows, 1, 1, 1);
        }
        ChoiceWidget choiceWidget = new ChoiceWidget();
        choiceWidget.setIgnoreCase(true);
        choiceWidget.setEditable(true);
        choiceWidget.setValues(stringArray);
        choiceWidget.setText(string2);
        choiceWidget.addChangeListener(this.changeSupport);
        if (string3 != null && string3.length() > 0) {
            choiceWidget.setToolTipText(string3);
        }
        this.gh.add(choiceWidget, 1, this.rows, 1, 1, 17);
        if (this.defaultFocus == null) {
            this.defaultFocus = choiceWidget;
        }
    }

    private String getGlobalConfirmMessage() {
        if (this.sameChoices.length < 2) {
            return null;
        }
        return RESOURCES.getString("choice.global.confirm", "" + this.sameChoices.length, this.sameChoices[0].getDisplayValue(), this.getCommitValue());
    }
}

