/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class RelationshipsBean
extends PropertyBean {
    public static Icon IMG = Grammar.V55.getMeta(new TagPath("FAM")).getImage().getOverLayed(MetaProperty.IMG_LINK);
    private PropertyTableWidget table;
    private Map<Property, String> relationships = new HashMap<Property, String>();

    public RelationshipsBean() {
        this.table = new PropertyTableWidget();
        this.table.setVisibleRowCount(2);
        this.setLayout(new BorderLayout());
        this.add("Center", this.table);
    }

    public void removeNotify() {
        REGISTRY.put("relcols", this.table.getColumnLayout());
        super.removeNotify();
    }

    protected void commitImpl(Property property) {
    }

    protected void setPropertyImpl(Property property) {
        this.relationships.clear();
        Model model = null;
        if (property instanceof Indi) {
            model = this.getModel((Indi)property);
        }
        if (property instanceof Fam) {
            model = this.getModel((Fam)property);
        }
        this.table.setModel(model);
        this.table.setColumnLayout(REGISTRY.get("relcols", ""));
    }

    private Model getModel(Fam fam) {
        Property property;
        TagPath[] tagPathArray = new TagPath[]{new TagPath(".", RESOURCES.getString("relationship")), new TagPath("*:..", Gedcom.getName("INDI")), new TagPath("*:..:NAME"), new TagPath("*:..:BIRT:DATE")};
        ArrayList<Property> arrayList = new ArrayList<Property>();
        Property property2 = fam.getProperty("HUSB");
        if (property2 instanceof PropertyHusband && property2.isValid()) {
            this.relationships.put(property2, ((PropertyHusband)property2).getPropertyNameAsParent());
            arrayList.add(property2);
        }
        if ((property = fam.getProperty("WIFE")) instanceof PropertyWife && property.isValid()) {
            this.relationships.put(property, ((PropertyWife)property).getPropertyNameAsParent());
            arrayList.add(property);
        }
        for (Property property3 : fam.getProperties("CHIL")) {
            if (!(property3 instanceof PropertyXRef) || !property3.isValid()) continue;
            this.relationships.put(property3, property3.getPropertyName());
            arrayList.add(property3);
        }
        return new Model(fam.getGedcom(), tagPathArray, arrayList);
    }

    private Model getModel(Indi indi) {
        TagPath[] tagPathArray = new TagPath[]{new TagPath(".", RESOURCES.getString("relationship")), new TagPath("*:..", Gedcom.getName("INDI")), new TagPath("*:..:NAME"), new TagPath("*:..:BIRT:DATE"), new TagPath("..", Gedcom.getName("FAM"))};
        ArrayList<Property> arrayList = new ArrayList<Property>();
        Fam fam = indi.getFamilyWhereBiologicalChild();
        if (fam != null) {
            Property property;
            Property property2 = fam.getProperty("HUSB");
            if (property2 instanceof PropertyXRef && property2.isValid()) {
                this.relationships.put(property2, ((PropertyHusband)property2).getPropertyNameAsParent());
                arrayList.add(property2);
            }
            if ((property = fam.getProperty("WIFE")) instanceof PropertyWife && property.isValid()) {
                this.relationships.put(property, ((PropertyWife)property).getPropertyNameAsParent());
                arrayList.add(property);
            }
        }
        for (Fam fam2 : indi.getFamiliesWhereSpouse()) {
            Property property = fam2.getProperty("HUSB");
            if (property instanceof PropertyXRef && property.isValid() && ((PropertyXRef)property).getTargetEntity() != indi) {
                this.relationships.put(property, property.getPropertyName());
                arrayList.add(property);
            } else {
                property = fam2.getProperty("WIFE");
                if (property instanceof PropertyXRef && property.isValid() && ((PropertyXRef)property).getTargetEntity() != indi) {
                    this.relationships.put(property, property.getPropertyName());
                    arrayList.add(property);
                }
            }
            for (PropertyChild propertyChild : fam2.getProperties(PropertyChild.class)) {
                if (!propertyChild.isValid()) continue;
                this.relationships.put(propertyChild, propertyChild.getPropertyName());
                arrayList.add(propertyChild);
            }
        }
        return new Model(indi.getGedcom(), tagPathArray, arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends AbstractPropertyTableModel {
        private TagPath[] columns;
        private List<Property> rows;

        public Model(Gedcom gedcom, TagPath[] tagPathArray, List<Property> list) {
            super(gedcom);
            this.columns = tagPathArray;
            this.rows = list;
        }

        @Override
        public int getNumCols() {
            return this.columns.length;
        }

        @Override
        public int getNumRows() {
            return this.rows.size();
        }

        @Override
        public TagPath getColPath(int n) {
            return this.columns[n];
        }

        @Override
        public Property getRowRoot(int n) {
            return this.rows.get(n);
        }

        @Override
        public String getCellValue(Property property, int n, int n2) {
            String string = (String)RelationshipsBean.this.relationships.get(property);
            return string != null ? string : super.getCellValue(property, n, n2);
        }
    }
}

