/*
 * Decompiled with CFR 0.152.
 */
package genj.fo;

import genj.fo.Document;
import genj.fo.HTMLFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public abstract class Format {
    protected static final Logger LOG = Logger.getLogger("genj.fo");
    private static Format[] formats;
    public static final Format DEFAULT;
    private String format;
    private String extension;
    private boolean isExternalizedFiles;
    private Map<File, TemplatesCache> xslCache = new HashMap<File, TemplatesCache>();

    protected Format(String string, String string2, boolean bl) {
        this.format = string;
        this.extension = string2;
        this.isExternalizedFiles = bl;
    }

    public String getFileExtension() {
        return this.extension;
    }

    public String getFormat() {
        return this.format;
    }

    public String toString() {
        return this.format;
    }

    public boolean equals(Object object) {
        return object instanceof Format ? this.format.equals(((Format)object).format) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externalizeFiles(Document document, File file) throws IOException {
        File[] fileArray = document.getImages();
        if (fileArray.length > 0) {
            File file2 = new File(file.getParentFile(), file.getName() + ".images");
            if (!file2.mkdirs()) {
                throw new IOException("cannot create directory " + file2);
            }
            if (file2.exists()) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = fileArray[i];
                    File file4 = new File(file2, file3.getName());
                    FileChannel fileChannel = null;
                    AbstractInterruptibleChannel abstractInterruptibleChannel = null;
                    long l = -1L;
                    try {
                        fileChannel = new FileInputStream(file3).getChannel();
                        l = fileChannel.size();
                        abstractInterruptibleChannel = new FileOutputStream(file4).getChannel();
                        fileChannel.transferTo(0L, l, (WritableByteChannel)((Object)abstractInterruptibleChannel));
                        document.setImage(file3, file2.getName() + "/" + file4.getName());
                        continue;
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, "Copying '" + file3 + "' to '" + file4 + "' failed (size=" + l + ")", throwable);
                        continue;
                    }
                    finally {
                        try {
                            abstractInterruptibleChannel.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
    }

    public boolean supports(Document document) {
        return true;
    }

    public void format(Document document, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        if (this.getFileExtension() != null) {
            if (file == null) {
                throw new IOException("Formatter requires output file");
            }
            fileOutputStream = new FileOutputStream(file);
            if (this.isExternalizedFiles) {
                this.externalizeFiles(document, file);
            }
        }
        this.format(document, fileOutputStream);
    }

    public void format(Document document, OutputStream outputStream) throws IOException {
        document.close();
        try {
            this.formatImpl(document, outputStream);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "unexpected expection formatting " + document.getTitle(), throwable);
            if (throwable instanceof OutOfMemoryError) {
                throw new IOException("out of memory");
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected abstract void formatImpl(Document var1, OutputStream var2) throws Throwable;

    protected Templates getTemplates(String string) {
        File file = new File(string);
        long l = file.lastModified();
        TemplatesCache templatesCache = this.xslCache.get(file);
        if (templatesCache != null && templatesCache.timestamp == l) {
            return templatesCache.templates;
        }
        templatesCache = new TemplatesCache();
        templatesCache.timestamp = l;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            templatesCache.templates = transformerFactory.newTemplates(new StreamSource(file));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException("Exception reading templates from " + string + ": " + transformerConfigurationException.getMessage());
        }
        this.xslCache.put(file, templatesCache);
        return templatesCache.templates;
    }

    public static Format getFormat(String string) {
        Format[] formatArray = Format.getFormats();
        for (int i = 0; i < formatArray.length; ++i) {
            if (!formatArray[i].getFormat().equals(string)) continue;
            return formatArray[i];
        }
        return DEFAULT;
    }

    public static Format[] getFormats() {
        if (formats != null) {
            return formats;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        arrayList.add(DEFAULT);
        Iterator<Format> iterator = ServiceRegistry.lookupProviders(Format.class);
        while (iterator.hasNext()) {
            Object object;
            try {
                object = iterator.next();
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
            catch (Throwable throwable) {
                if (throwable.getCause() != throwable) {
                    object = throwable.getCause();
                }
                LOG.log(Level.WARNING, "Encountered exception loading Format: " + ((Throwable)object).getMessage());
            }
        }
        formats = arrayList.toArray(new Format[arrayList.size()]);
        return formats;
    }

    static {
        DEFAULT = new HTMLFormat();
    }

    private class TemplatesCache {
        Templates templates;
        long timestamp;

        private TemplatesCache() {
        }
    }
}

