/*
 * Decompiled with CFR 0.152.
 */
package genj.fo;

import genj.fo.Document;
import genj.fo.Format;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.NestedBlockLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FormatOptionsWidget
extends JPanel {
    private Action validAction;
    private Document doc;
    private FileChooserWidget chooseFile;
    private JComboBox chooseFormat;

    public FormatOptionsWidget(Document document, Registry registry) {
        this.setLayout(new NestedBlockLayout("<col><row><label/><file wx=\"1\"/></row><row><label/><format wx=\"1\"/></row></col>"));
        this.doc = document;
        this.chooseFile = new FileChooserWidget();
        String string = registry.get("file", (String)null);
        if (string != null) {
            File file = new File(string);
            this.chooseFile.setFile(file);
            this.chooseFile.setDirectory(file.getParent());
        }
        this.add(new JLabel("File"));
        this.add(this.chooseFile);
        this.chooseFormat = new JComboBox<Format>(Format.getFormats());
        this.chooseFormat.setSelectedItem(Format.getFormat(registry.get("format", (String)null)));
        this.chooseFormat.setEditable(false);
        this.add(new JLabel("Format"));
        this.add(this.chooseFormat);
        this.chooseFile.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FormatOptionsWidget.this.validateOptions(false);
            }
        });
        this.chooseFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatOptionsWidget.this.validateOptions(true);
            }
        });
    }

    public void remember(Registry registry) {
        registry.put("format", this.getFormat().getFormat());
        registry.put("file", this.getFile().getAbsolutePath());
    }

    public Format getFormat() {
        return (Format)this.chooseFormat.getSelectedItem();
    }

    public File getFile() {
        Format format;
        File file = this.chooseFile.getFile();
        if (file.getPath().length() == 0) {
            return null;
        }
        if (file.getParentFile() == null) {
            file = new File(EnvironmentChecker.getProperty("user.home", ".", "home directory for report output"), file.getPath());
        }
        if ((format = this.getFormat()).getFileExtension() == null) {
            return file;
        }
        String string = file.getPath();
        Format[] formatArray = Format.getFormats();
        for (int i = 0; i < formatArray.length; ++i) {
            String string2 = "." + formatArray[i].getFileExtension();
            if (!string.endsWith(string2)) continue;
            string = string.substring(0, string.length() - string2.length());
        }
        return new File(string + "." + format.getFileExtension());
    }

    public void connect(Action action) {
        this.validAction = action;
        this.validateOptions(true);
    }

    private void validateOptions(boolean bl) {
        Format format = this.getFormat();
        boolean bl2 = true;
        if (format.getFileExtension() != null && this.chooseFile.isEmpty()) {
            bl2 = false;
        }
        this.chooseFile.setEnabled(format.getFileExtension() != null);
        if (!format.supports(this.doc)) {
            bl2 = false;
        }
        if (bl) {
            this.chooseFile.setFile(this.getFile());
        }
        this.validAction.setEnabled(bl2);
    }
}

