/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyXRef;

public class Entity
extends Property {
    private Gedcom gedcom;
    private String id;
    private String value;

    protected Entity(String string, String string2) {
        super(string);
        this.id = string2;
    }

    void addNotify(Gedcom gedcom) {
        this.gedcom = gedcom;
        gedcom.propagateEntityAdded(this);
    }

    void beforeDelNotify() {
        this.delProperties();
        this.gedcom.propagateEntityDeleted(this);
        this.gedcom = null;
    }

    public PropertyChange getLastChange() {
        return (PropertyChange)this.getProperty("CHAN");
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public Entity getEntity() {
        return this;
    }

    public boolean isConnected() {
        for (PropertyXRef propertyXRef : this.getProperties(PropertyXRef.class)) {
            if (!propertyXRef.isValid()) continue;
            return true;
        }
        return false;
    }

    public void setId(String string) throws GedcomException {
        String string2 = this.id;
        this.id = string;
        if (this.gedcom != null) {
            try {
                this.gedcom.propagateEntityIDChanged(this, string2);
            }
            catch (Throwable throwable) {
                this.id = string2;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getToStringPrefix(bl));
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.getPropertyName());
        }
        if (bl) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getId());
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    protected String getToStringPrefix(boolean bl) {
        return this.getPropertyName();
    }

    public String getValue() {
        return this.value != null ? this.value : "";
    }

    public void setValue(String string) {
        this.value = string;
    }

    public int compareTo(Property property) {
        if (!(property instanceof Entity)) {
            throw new IllegalArgumentException("Cannot compare entity to property");
        }
        return this.getID() - ((Entity)property).getID();
    }

    private int getID() throws NumberFormatException {
        int n;
        int n2 = this.id.length() - 1;
        for (n = 0; n <= n2 && !Character.isDigit(this.id.charAt(n)); ++n) {
        }
        while (n2 >= n && !Character.isDigit(this.id.charAt(n2))) {
            --n2;
        }
        if (n2 < n) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(this.id.substring(n, n2 + 1));
    }

    public String format(String string, String string2) {
        Property property = this.getProperty(string);
        return property != null ? property.format(string2) : "";
    }

    void propagateXRefLinked(PropertyXRef propertyXRef, PropertyXRef propertyXRef2) {
        if (this.gedcom != null) {
            this.gedcom.propagateXRefLinked(propertyXRef, propertyXRef2);
        }
    }

    void propagateXRefUnlinked(PropertyXRef propertyXRef, PropertyXRef propertyXRef2) {
        if (this.gedcom != null) {
            this.gedcom.propagateXRefUnlinked(propertyXRef, propertyXRef2);
        }
    }

    void propagatePropertyAdded(Property property, int n, Property property2) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyAdded(this, property, n, property2);
        }
    }

    void propagatePropertyDeleted(Property property, int n, Property property2) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyDeleted(this, property, n, property2);
        }
    }

    void propagatePropertyChanged(Property property, String string) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyChanged(this, property, string);
        }
    }

    void propagatePropertyMoved(Property property, Property property2, int n, int n2) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyMoved(property, property2, n, n2);
        }
    }
}

