/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import java.text.Collator;
import javax.swing.ImageIcon;

public class PropertyAge
extends Property {
    public static final ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:BIRT:AGE")).getImage();
    private Delta age = new Delta(0, 0, 0);
    private int younger_exactly_older = 0;
    private String ageAsString;
    public static String[] PHRASES = new String[]{"CHILD", "INFANT", "STILLBORN"};

    public PropertyAge(String string) {
        super(string);
    }

    public boolean isValid() {
        Collator collator = this.getGedcom().getCollator();
        if (this.ageAsString == null) {
            return true;
        }
        for (int i = 0; i < PHRASES.length; ++i) {
            if (collator.compare(PHRASES[i], this.ageAsString) != 0) continue;
            return true;
        }
        return false;
    }

    void afterAddNotify() {
        super.afterAddNotify();
        this.updateAge();
    }

    public static String getLabelForAge() {
        return Gedcom.getName("AGE");
    }

    public String getValue() {
        if (this.ageAsString != null) {
            return this.ageAsString;
        }
        if (this.younger_exactly_older > 0) {
            return ">" + this.age.getValue();
        }
        if (this.younger_exactly_older < 0) {
            return "<" + this.age.getValue();
        }
        return this.age.getValue();
    }

    public void setValue(String string) {
        String string2 = this.getValue();
        if (string.startsWith(">")) {
            string = string.substring(1);
            this.younger_exactly_older = 1;
        } else if (string.startsWith("<")) {
            string = string.substring(1);
            this.younger_exactly_older = -1;
        }
        this.ageAsString = this.age.setValue(string) ? null : string;
        this.propagatePropertyChanged(this, string2);
    }

    public void setValue(Delta delta) {
        String string = this.getValue();
        this.age.setValue(delta);
        this.propagatePropertyChanged(this, string);
    }

    public boolean updateAge() {
        String string = this.getValue();
        Delta delta = Delta.get(this.getEarlier(), this.getLater());
        if (delta == null) {
            return false;
        }
        this.age = delta;
        this.younger_exactly_older = 0;
        this.ageAsString = null;
        this.propagatePropertyChanged(this, string);
        return true;
    }

    public int compareTo(Property property) {
        if (!this.isValid() || !property.isValid()) {
            return super.compareTo(property);
        }
        return this.age.compareTo(((PropertyAge)property).age);
    }

    public PointInTime getEarlier() {
        Property property;
        Entity entity = this.getEntity();
        if (entity instanceof Fam) {
            property = this.getParent();
            if (property.getTag().equals("HUSB")) {
                entity = ((Fam)entity).getHusband();
            }
            if (property.getTag().equals("WIFE")) {
                entity = ((Fam)entity).getWife();
            }
        }
        if (!(entity instanceof Indi)) {
            return null;
        }
        property = ((Indi)entity).getBirthDate();
        return property != null ? ((PropertyDate)property).getStart() : null;
    }

    public PointInTime getLater() {
        Property property = this.getParent();
        if (property.getTag().equals("HUSB") || property.getTag().equals("WIFE")) {
            property = property.getParent();
        }
        if (!(property instanceof PropertyEvent)) {
            return null;
        }
        PropertyDate propertyDate = ((PropertyEvent)property).getDate();
        return propertyDate != null ? propertyDate.getStart() : null;
    }
}

