/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.MetaProperty;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.time.PointInTime;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class PropertyChange
extends Property
implements MultiLineProperty {
    private static final DecimalFormat decimal = new DecimalFormat("00");
    public static final String CHAN = "CHAN";
    public static final String TIME = "TIME";
    public static final String DATE = "DATE";
    private long time = -1L;

    public PropertyChange() {
        super(CHAN);
        this.setTime(System.currentTimeMillis());
    }

    public PropertyChange(String string) {
        super(string);
        this.assertTag(CHAN);
    }

    public boolean isReadOnly() {
        return true;
    }

    public String getDisplayValue() {
        return this.time < 0L ? "" : this.getDateDisplayValue() + ", " + this.getTimeDisplayValue();
    }

    public String getDateDisplayValue() {
        return this.time < 0L ? "" : PointInTime.getPointInTime(this.toLocal(this.time)).toString();
    }

    public String getTimeDisplayValue() {
        return this.time <= 0L ? "" : this.toString(this.toLocal(this.time));
    }

    private long toLocal(long l) {
        Calendar calendar = Calendar.getInstance();
        return l + (long)calendar.get(15) + (long)calendar.get(16);
    }

    private String toString(long l) {
        long l2 = l / 1000L % 60L;
        long l3 = l / 1000L / 60L % 60L;
        long l4 = l / 1000L / 60L / 60L % 24L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(decimal.format(l4));
        stringBuffer.append(':');
        stringBuffer.append(decimal.format(l3));
        stringBuffer.append(':');
        stringBuffer.append(decimal.format(l2));
        return stringBuffer.toString();
    }

    public MultiLineProperty.Collector getLineCollector() {
        return new DateTimeCollector();
    }

    public MultiLineProperty.Iterator getLineIterator() {
        return new DateTimeIterator();
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        if (this.time == l) {
            return;
        }
        String string = this.getValue();
        this.time = l;
        this.propagatePropertyChanged(this, string);
    }

    public void setValue(String string) {
        String string2 = this.getValue();
        int n = string.indexOf(44);
        if (n < 0) {
            return;
        }
        try {
            this.time = 0L;
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), ":");
            if (stringTokenizer.hasMoreTokens()) {
                this.time += (long)(Integer.parseInt(stringTokenizer.nextToken()) * 60 * 60 * 1000);
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.time += (long)(Integer.parseInt(stringTokenizer.nextToken()) * 60 * 1000);
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.time += (long)(Integer.parseInt(stringTokenizer.nextToken()) * 1000);
            }
            this.time += PointInTime.getPointInTime(string.substring(0, n)).getTimeMillis();
            this.getGedcom().updateLastChange(this);
        }
        catch (Throwable throwable) {
            this.time = -1L;
        }
        this.propagatePropertyChanged(this, string2);
    }

    public String getValue() {
        return this.time < 0L ? "" : PointInTime.getPointInTime(this.time).getValue() + ',' + this.toString(this.time);
    }

    public int compareTo(Property property) {
        if (this.time < ((PropertyChange)property).time) {
            return -1;
        }
        if (this.time > ((PropertyChange)property).time) {
            return 1;
        }
        return 0;
    }

    public void setPrivate(boolean bl, boolean bl2) {
    }

    static /* synthetic */ String access$300(PropertyChange propertyChange, long l) {
        return propertyChange.toString(l);
    }

    static class Monitor
    extends GedcomListenerAdapter {
        private Set<Entity> updated = new HashSet<Entity>();

        Monitor() {
        }

        private void update(Property property) {
            Entity entity = property.getEntity();
            if (this.updated.contains(entity)) {
                return;
            }
            while (property != null) {
                if (property instanceof PropertyChange) {
                    return;
                }
                property = property.getParent();
            }
            Gedcom.LOG.finer("updating CHAN for " + entity.getId());
            MetaProperty metaProperty = entity.getMetaProperty();
            if (!metaProperty.allows(PropertyChange.CHAN)) {
                return;
            }
            PropertyChange propertyChange = (PropertyChange)entity.getProperty(PropertyChange.CHAN);
            if (propertyChange == null) {
                propertyChange = (PropertyChange)entity.addProperty(new PropertyChange());
            } else {
                propertyChange.setTime(System.currentTimeMillis());
            }
            this.updated.add(entity);
            entity.getGedcom().updateLastChange(propertyChange);
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            this.update(entity);
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            this.updated.remove(entity);
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
            this.update(property2);
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            this.update(property);
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
            if (!(property2 instanceof PropertyChange)) {
                this.update(property);
            }
        }
    }

    private class DateTimeIterator
    implements MultiLineProperty.Iterator {
        int i = 0;
        private String[] tags = new String[]{"CHAN", "DATE", "TIME"};
        private String[] values = new String[]{"", PointInTime.getPointInTime(PropertyChange.access$200(PropertyChange.this)).getValue(), PropertyChange.access$300(PropertyChange.this, PropertyChange.access$200(PropertyChange.this))};

        private DateTimeIterator() {
        }

        public void setValue(String string) {
        }

        public int getIndent() {
            return this.i;
        }

        public String getTag() {
            return this.tags[this.i];
        }

        public String getValue() {
            return this.values[this.i];
        }

        public boolean next() {
            return PropertyChange.this.time >= 0L && ++this.i != this.tags.length;
        }
    }

    private class DateTimeCollector
    implements MultiLineProperty.Collector {
        private String dateCollected;
        private String timeCollected;

        private DateTimeCollector() {
        }

        public boolean append(int n, String string, String string2) {
            if (n == 1 && PropertyChange.DATE.equals(string)) {
                this.dateCollected = string2;
                return true;
            }
            if (n == 2 && PropertyChange.TIME.equals(string)) {
                this.timeCollected = string2;
                return true;
            }
            return false;
        }

        public String getValue() {
            return this.dateCollected + ',' + this.timeCollected;
        }
    }
}

