/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;

public class PropertyHusband
extends PropertyXRef {
    static final String LABEL_FATHER = Gedcom.resources.getString("HUSB.father");

    PropertyHusband() {
        super("HUSB");
    }

    PropertyHusband(String string) {
        super(string);
        this.assertTag("HUSB");
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.husb.veto");
    }

    public Indi getHusband() {
        return (Indi)this.getTargetEntity();
    }

    public String getPropertyNameAsParent() {
        Indi indi = this.getHusband();
        if (indi == null) {
            return LABEL_FATHER;
        }
        switch (indi.getSex()) {
            default: {
                return LABEL_FATHER;
            }
            case 2: 
        }
        return PropertyWife.LABEL_MOTHER;
    }

    public void link() throws GedcomException {
        PropertyFamilySpouse propertyFamilySpouse;
        Fam fam;
        try {
            fam = (Fam)this.getEntity();
        }
        catch (ClassCastException classCastException) {
            throw new GedcomException(resources.getString("error.noenclosingfam"));
        }
        if (fam.getHusband() != null) {
            throw new GedcomException(resources.getString("error.already.spouse", fam.getHusband().toString(), fam.toString()));
        }
        Indi indi = (Indi)this.getCandidate();
        if (fam.getWife() == indi) {
            throw new GedcomException(resources.getString("error.already.spouse", indi.toString(), fam.toString()));
        }
        if (indi.isDescendantOf(fam)) {
            throw new GedcomException(resources.getString("error.already.descendant", indi.toString(), fam.toString()));
        }
        Property[] propertyArray = indi.getProperties(new TagPath("INDI:FAMS"));
        for (int i = 0; i < propertyArray.length; ++i) {
            propertyFamilySpouse = (PropertyFamilySpouse)propertyArray[i];
            if (!propertyFamilySpouse.isCandidate(fam)) continue;
            this.link(propertyFamilySpouse);
            return;
        }
        propertyFamilySpouse = new PropertyFamilySpouse();
        indi.addProperty(propertyFamilySpouse);
        this.link(propertyFamilySpouse);
    }

    public String getTargetType() {
        return "INDI";
    }
}

