/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;

public class PropertyRelationship
extends PropertyChoiceValue {
    private TagPath anchor = null;

    public PropertyRelationship(String string) {
        super(string);
        this.assertTag("RELA");
    }

    public String getValue() {
        String string = super.getValue();
        TagPath tagPath = this.getAnchor();
        if (tagPath != null && tagPath.length() > 0) {
            string = string + '@' + tagPath.toString();
        }
        return string;
    }

    public String getDisplayValue() {
        return super.getValue();
    }

    public void setValue(String string) {
        int n = string.lastIndexOf(64);
        if (n >= 0) {
            try {
                this.anchor = new TagPath(string.substring(n + 1));
                if (!this.getAnchor().equals(this.anchor)) {
                    PropertyAssociation propertyAssociation = (PropertyAssociation)this.getParent();
                    PropertyXRef propertyXRef = propertyAssociation.getTarget();
                    propertyAssociation.unlink();
                    propertyXRef.getParent().delProperty(propertyXRef);
                    propertyAssociation.link();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            string = string.substring(0, n);
        }
        super.setValue(string);
    }

    Property getTarget() {
        Property property = this.getParent();
        if (property instanceof PropertyAssociation) {
            return ((PropertyAssociation)property).getTarget();
        }
        return null;
    }

    TagPath getAnchor() {
        Property property;
        Property property2 = this.getTarget();
        if (property2 != null && !((property = property2.getParent()) instanceof Entity) && property != null) {
            TagPath tagPath = property.getPath(false);
            return property.getEntity().getProperty(tagPath) == property ? tagPath : property.getPath(true);
        }
        return this.anchor;
    }
}

