/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;

public class PropertySex
extends Property {
    private static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(new TagPath("INDI:SEX")).getImage();
    private static final ImageIcon IMG_MALE = Grammar.V55.getMeta(new TagPath("INDI:SEX")).getImage("male");
    private static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(new TagPath("INDI:SEX")).getImage("female");
    public static final String TXT_SEX = Gedcom.getResources().getString("prop.sex");
    public static final String TXT_MALE = Gedcom.getResources().getString("prop.sex.male");
    public static final String TXT_FEMALE = Gedcom.getResources().getString("prop.sex.female");
    public static final String TXT_UNKNOWN = Gedcom.getResources().getString("prop.sex.unknown");
    public static final int UNKNOWN = 0;
    public static final int MALE = 1;
    public static final int FEMALE = 2;
    private int sex = 0;
    private String sexAsString;

    PropertySex(String string) {
        super(string);
        this.assertTag("SEX");
    }

    PropertySex() {
        super("SEX");
    }

    public static ImageIcon getImage(int n) {
        switch (n) {
            case 1: {
                return IMG_MALE;
            }
            case 2: {
                return IMG_FEMALE;
            }
        }
        return IMG_UNKNOWN;
    }

    public ImageIcon getImage(boolean bl) {
        if (bl && !this.isValid()) {
            return super.getImage(true);
        }
        switch (this.sex) {
            case 1: {
                return IMG_MALE;
            }
            case 2: {
                return IMG_FEMALE;
            }
        }
        return super.getImage(bl);
    }

    public boolean isValid() {
        return this.sexAsString == null;
    }

    public static String getLabelForSex(int n) {
        switch (n) {
            case 1: {
                return Gedcom.getResources().getString("prop.sex.male");
            }
            case 2: {
                return Gedcom.getResources().getString("prop.sex.female");
            }
        }
        return Gedcom.getResources().getString("prop.sex.unknown");
    }

    public int getSex() {
        return this.sex;
    }

    public String getValue() {
        if (this.sexAsString != null) {
            return this.sexAsString;
        }
        if (this.sex == 1) {
            return "M";
        }
        if (this.sex == 2) {
            return "F";
        }
        return "";
    }

    public String getDisplayValue() {
        return PropertySex.getLabelForSex(this.sex);
    }

    public void setSex(int n) {
        String string = this.getValue();
        this.sexAsString = null;
        this.sex = n;
        this.propagatePropertyChanged(this, string);
    }

    public void setValue(String string) {
        String string2 = this.getValue();
        if (string.trim().length() > 1) {
            this.sexAsString = string;
        } else if (string.length() == 0) {
            this.sexAsString = null;
            this.sex = 0;
        } else {
            switch (string.charAt(0)) {
                case 'F': 
                case 'f': {
                    this.sex = 2;
                    this.sexAsString = null;
                    break;
                }
                case 'M': 
                case 'm': {
                    this.sex = 1;
                    this.sexAsString = null;
                    break;
                }
                default: {
                    this.sexAsString = string;
                }
            }
        }
        this.propagatePropertyChanged(this, string2);
    }

    public static boolean isSex(int n) {
        return n == 1 || n == 2;
    }

    public static int calcOppositeSex(int n, int n2) {
        if (n == 1) {
            return 2;
        }
        if (n == 2) {
            return 1;
        }
        return n2;
    }

    public static int calcOppositeSex(Indi indi, int n) {
        if (indi == null) {
            return n;
        }
        return PropertySex.calcOppositeSex(indi.getSex(), n);
    }
}

