/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyVisitor;
import genj.gedcom.PropertyXRef;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagPath {
    private String name = null;
    private String[] tags;
    private int[] qualifiers;
    private int len;
    private int hash = 0;
    public static final char SEPARATOR = ':';
    public static final String SEPARATOR_STRING = String.valueOf(':');
    private static final char SELECTOR = '#';

    public TagPath(String string) throws IllegalArgumentException {
        this(string, null);
    }

    public TagPath(String[] stringArray, String string) throws IllegalArgumentException {
        this.name = string;
        this.len = stringArray.length;
        if (this.len == 0) {
            throw new IllegalArgumentException("No valid path '" + stringArray + "'");
        }
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) {
                throw new IllegalArgumentException("Empty tag in '" + Arrays.toString(stringArray) + "' is not valid");
            }
            this.set(i, string2);
        }
    }

    public TagPath(String string, String string2) throws IllegalArgumentException {
        this(string.split(SEPARATOR_STRING), string2);
    }

    private void set(int n, String string) {
        int n2 = -1;
        int n3 = string.indexOf(35);
        if (n3 > 0) {
            try {
                n2 = Integer.parseInt(string.substring(n3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Illegal tag qualifier in '" + string + "'");
            }
            string = string.substring(0, n3);
        }
        this.tags[n] = string;
        this.qualifiers[n] = n2;
        this.hash += string.hashCode();
    }

    public TagPath(TagPath tagPath) {
        this(tagPath, tagPath.len);
    }

    public TagPath(TagPath tagPath, int n) {
        this.len = n;
        this.tags = tagPath.tags;
        this.qualifiers = tagPath.qualifiers;
        for (int i = 0; i < this.len; ++i) {
            this.hash += this.tags[i].hashCode();
        }
    }

    public TagPath(TagPath tagPath, String string) {
        this.len = tagPath.len + 1;
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        System.arraycopy(tagPath.tags, 0, this.tags, 0, tagPath.len);
        System.arraycopy(tagPath.qualifiers, 0, this.qualifiers, 0, tagPath.len);
        this.tags[this.len - 1] = string;
        this.qualifiers[this.len - 1] = -1;
        this.hash = tagPath.hash + string.hashCode();
    }

    TagPath(Stack<String> stack) throws IllegalArgumentException {
        this.len = stack.size();
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.set(i, stack.pop().toString());
        }
    }

    public boolean startsWith(TagPath tagPath) {
        if (tagPath.len > this.len) {
            return false;
        }
        for (int i = 0; i < tagPath.len; ++i) {
            if (this.tags[i].equals(tagPath.tags[i]) && this.qualifiers[i] == tagPath.qualifiers[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TagPath)) {
            return false;
        }
        TagPath tagPath = (TagPath)object;
        if (tagPath.len != this.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.tags[i].equals(tagPath.tags[i]) && this.qualifiers[i] == tagPath.qualifiers[i]) continue;
            return false;
        }
        return true;
    }

    public String get(int n) {
        return this.tags[n];
    }

    public String getFirst() {
        return this.get(0);
    }

    public String getLast() {
        return this.get(this.len - 1);
    }

    public int length() {
        return this.len;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.len; ++i) {
            if (i > 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(this.tags[i]);
            if (this.qualifiers[i] < 0) continue;
            stringBuffer.append('#');
            stringBuffer.append(this.qualifiers[i]);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public String getName() {
        if (this.name == null) {
            int n = this.length() - 1;
            String string = this.get(n);
            while (n > 1 && !Character.isJavaIdentifierPart(string.charAt(0))) {
                string = this.get(--n);
            }
            this.name = Gedcom.getName(string);
            if (n > 1 && Character.isLetter(this.get(n - 1).charAt(0))) {
                String string2 = Gedcom.getName(this.get(n - 1));
                if (!Pattern.compile(".*" + string2 + ".*", 2).matcher(this.name).find()) {
                    this.name = this.name + " - " + string2;
                }
            }
        }
        return this.name;
    }

    public static TagPath get(Property property) {
        String string = property.getTag();
        while (!(property instanceof Entity)) {
            property = property.getParent();
            string = property.getTag() + ":" + string;
        }
        return new TagPath(string);
    }

    public static TagPath[] toArray(Collection<TagPath> collection) {
        return collection.toArray(new TagPath[collection.size()]);
    }

    public static TagPath[] toArray(String[] stringArray) {
        TagPath[] tagPathArray = new TagPath[stringArray.length];
        for (int i = 0; i < tagPathArray.length; ++i) {
            tagPathArray[i] = new TagPath(stringArray[i]);
        }
        return tagPathArray;
    }

    public void iterate(Property property, PropertyVisitor propertyVisitor) {
        this.iterate(property, propertyVisitor, true);
    }

    public void iterate(Property property, PropertyVisitor propertyVisitor, boolean bl) {
        String string = this.get(0);
        char c = string.charAt(0);
        if (c == '.' || c == '*') {
            this.iterate(0, property, propertyVisitor, bl);
        } else if (string.equals(property.getTag())) {
            this.iterate(1, property, propertyVisitor, bl);
        }
    }

    private boolean iterate(int n, Property property, PropertyVisitor propertyVisitor, boolean bl) {
        String string;
        while (true) {
            if (n == this.length()) {
                return propertyVisitor.leaf(property);
            }
            string = this.get(n);
            if (string.equals("..")) {
                if (property.getParent() != null) {
                    property = property.getParent();
                }
            } else if (!string.equals(".")) {
                if (!string.equals("*")) break;
                if (!(property instanceof PropertyXRef) || ((PropertyXRef)property).getTarget() == null) {
                    return false;
                }
                property = ((PropertyXRef)property).getTarget();
            }
            ++n;
        }
        if (!propertyVisitor.recursion(property, string)) {
            return false;
        }
        int n2 = this.qualifiers[n];
        int n3 = 0;
        for (int i = 0; i < property.getNoOfProperties(); ++i) {
            Property property2 = property.getProperty(i);
            if (!bl && property.getProperty(property2.getTag()) != property2 || !string.equals(property2.getTag()) || n2 >= 0 && n2 != n3++ || this.iterate(n + 1, property2, propertyVisitor, bl)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String string) {
        for (int i = 0; i < this.len; ++i) {
            if (!this.tags[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

