/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.GedcomException;
import genj.gedcom.Options;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.FrenchRCalendar;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.HebrewCalendar;
import genj.gedcom.time.JulianCalendar;
import genj.util.DirectAccessTokenizer;
import genj.util.Resources;
import genj.util.WordBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointInTime
implements Comparable<PointInTime> {
    public static final int FORMAT_GEDCOM = 0;
    public static final int FORMAT_SHORT = 1;
    public static final int FORMAT_LONG = 2;
    public static final int FORMAT_NUMERIC = 3;
    static final Resources resources = Resources.get(PointInTime.class);
    public static final int UNKNOWN = Integer.MAX_VALUE;
    public static final GregorianCalendar GREGORIAN = new GregorianCalendar();
    public static final JulianCalendar JULIAN = new JulianCalendar();
    public static final HebrewCalendar HEBREW = new HebrewCalendar();
    public static final FrenchRCalendar FRENCHR = new FrenchRCalendar();
    public static final Calendar[] CALENDARS = new Calendar[]{GREGORIAN, JULIAN, HEBREW, FRENCHR};
    protected Calendar calendar = GREGORIAN;
    private int day = Integer.MAX_VALUE;
    private int month = Integer.MAX_VALUE;
    private int year = Integer.MAX_VALUE;
    private int jd = Integer.MAX_VALUE;
    private static DateFormat NUMERICDATEFORMAT = PointInTime.initNumericDateFormat();

    public PointInTime() {
    }

    public PointInTime(Calendar calendar) {
        this.calendar = calendar;
    }

    public PointInTime(java.util.Calendar calendar) {
        this.calendar = GREGORIAN;
        this.day = calendar.get(5) - 1;
        this.month = calendar.get(2);
        this.year = calendar.get(1);
    }

    public PointInTime(int n, int n2, int n3) {
        this(n, n2, n3, GREGORIAN);
    }

    public PointInTime(int n, int n2, int n3, Calendar calendar) {
        this.day = n;
        this.month = n2;
        this.year = n3;
        this.calendar = calendar;
        this.jd = Integer.MAX_VALUE;
    }

    public PointInTime(String string) throws GedcomException {
        if (string == null || string.length() != 8) {
            throw new GedcomException(resources.getString("pit.noyyyymmdd", string));
        }
        try {
            this.year = Integer.parseInt(string.substring(0, 4));
            this.month = Integer.parseInt(string.substring(4, 6)) - 1;
            this.day = Integer.parseInt(string.substring(6, 8)) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new GedcomException(resources.getString("pit.noyyyymmdd", string));
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public static PointInTime getNow() {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        return new PointInTime(calendar.get(5) - 1, calendar.get(2), calendar.get(1));
    }

    public static PointInTime getPointInTime(String string) {
        PointInTime pointInTime = new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, GREGORIAN);
        pointInTime.set(string);
        return pointInTime;
    }

    public static PointInTime getPointInTime(long l) {
        long l2 = 2440588L + l / 24L / 60L / 60L / 1000L;
        return GREGORIAN.toPointInTime((int)l2);
    }

    public long getTimeMillis() throws GedcomException {
        return ((long)this.getJulianDay() - 2440588L) * 24L * 60L * 60L * 1000L;
    }

    public PointInTime getPointInTime(Calendar calendar) throws GedcomException {
        if (this.calendar == calendar) {
            return this;
        }
        PointInTime pointInTime = new PointInTime();
        pointInTime.set(this);
        pointInTime.set(calendar);
        return pointInTime;
    }

    public int getJulianDay() throws GedcomException {
        if (this.jd == Integer.MAX_VALUE) {
            this.jd = this.calendar.toJulianDay(this);
        }
        return this.jd;
    }

    public void reset() {
        this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public String getDayOfWeek(boolean bl) throws GedcomException {
        return this.calendar.getDayOfWeek(this, bl);
    }

    public PointInTime add(int n, int n2, int n3) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.set(5, this.day != Integer.MAX_VALUE ? this.day + 1 : 1);
        calendar.set(2, this.month != Integer.MAX_VALUE ? this.month : 0);
        calendar.set(1, this.year != Integer.MAX_VALUE ? this.year : 0);
        calendar.add(5, n);
        calendar.add(2, n2);
        calendar.add(1, n3);
        this.set(calendar.get(5) - 1, calendar.get(2), calendar.get(1));
        return this;
    }

    public void set(Calendar calendar) throws GedcomException {
        if (this.day == Integer.MAX_VALUE && this.month == Integer.MAX_VALUE && this.year == Integer.MAX_VALUE) {
            this.calendar = calendar;
            return;
        }
        if (!this.isValid()) {
            throw new GedcomException(resources.getString("pit.invalid"));
        }
        if (!this.isComplete()) {
            throw new GedcomException(resources.getString("pit.incomplete"));
        }
        int n = this.getJulianDay();
        this.set(calendar.toPointInTime(n));
    }

    public void set(int n, int n2, int n3) {
        this.set(n, n2, n3, this.calendar);
    }

    public void set(int n, int n2, int n3, Calendar calendar) {
        this.day = n;
        this.month = n2;
        this.year = n3;
        this.calendar = calendar;
        this.jd = Integer.MAX_VALUE;
    }

    public void set(PointInTime pointInTime) {
        this.calendar = pointInTime.calendar;
        this.set(pointInTime.getDay(), pointInTime.getMonth(), pointInTime.getYear());
    }

    public boolean set(String string) {
        String string2;
        String string3;
        String string4;
        Object object;
        int n;
        string = string.trim();
        this.calendar = GREGORIAN;
        if (string.startsWith("@#")) {
            n = string.indexOf("@", 1);
            if (n < 0) {
                return false;
            }
            object = string.substring(0, n + 1);
            string = string.substring(n + 1);
            for (int i = 0; i < CALENDARS.length; ++i) {
                Calendar calendar = CALENDARS[i];
                if (!calendar.escape.equalsIgnoreCase((String)object)) continue;
                this.calendar = calendar;
                break;
            }
        }
        n = 0;
        if (this.calendar == GREGORIAN && string.endsWith("B.C.")) {
            n = 1;
            string = string.substring(0, string.length() - "B.C.".length()).trim();
        }
        if ((string4 = ((DirectAccessTokenizer)(object = new DirectAccessTokenizer(string, " ", true))).get(0)) == null) {
            this.reset();
            return true;
        }
        int n2 = 1;
        if ((string3 = ((DirectAccessTokenizer)object).get(n2++)) == null) {
            try {
                this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, this.addc(this.calendar.getYear(string4), n != 0));
            }
            catch (Throwable throwable) {
                return false;
            }
            return this.getYear() != Integer.MAX_VALUE;
        }
        if ((string2 = ((DirectAccessTokenizer)object).get(n2++)) == null) {
            try {
                if (this.calendar == FRENCHR) {
                    this.set(Integer.MAX_VALUE, Integer.MAX_VALUE, this.calendar.getYear(string4 + ' ' + string3));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.set(Integer.MAX_VALUE, this.calendar.parseMonth(string4), this.addc(this.calendar.getYear(string3), n != 0));
            }
            catch (Throwable throwable) {
                return false;
            }
            return this.getYear() != Integer.MAX_VALUE && this.getMonth() != Integer.MAX_VALUE;
        }
        string2 = string.substring(((DirectAccessTokenizer)object).getStart());
        try {
            this.set(Integer.parseInt(string4) - 1, this.calendar.parseMonth(string3), this.addc(this.calendar.getYear(string2), n != 0));
        }
        catch (Throwable throwable) {
            return false;
        }
        return this.getYear() != Integer.MAX_VALUE && this.getMonth() != Integer.MAX_VALUE && this.getDay() != Integer.MAX_VALUE;
    }

    private int addc(int n, boolean bl) {
        if (!bl) {
            return n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("no year 0 allowed");
        }
        return 0 - n;
    }

    public boolean isGregorian() {
        return this.getCalendar() == GREGORIAN;
    }

    public boolean isComplete() {
        return this.year != Integer.MAX_VALUE && this.month != Integer.MAX_VALUE && this.day != Integer.MAX_VALUE;
    }

    public boolean isValid() {
        if (this.jd != Integer.MAX_VALUE) {
            return true;
        }
        if (this.day == Integer.MAX_VALUE && this.month == Integer.MAX_VALUE && this.year == Integer.MAX_VALUE) {
            return false;
        }
        try {
            this.jd = this.calendar.toJulianDay(this);
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
        return this.jd != Integer.MAX_VALUE;
    }

    @Override
    public int compareTo(PointInTime pointInTime) {
        boolean bl;
        boolean bl2 = this.isValid();
        boolean bl3 = bl = pointInTime != null && pointInTime.isValid();
        if (!bl2 && !bl) {
            return 0;
        }
        if (!bl) {
            return 1;
        }
        if (!bl2) {
            return -1;
        }
        try {
            return this.getJulianDay() - pointInTime.getJulianDay();
        }
        catch (GedcomException gedcomException) {
            return 0;
        }
    }

    public String getValue() {
        return this.getValue(new WordBuffer()).toString();
    }

    public WordBuffer getValue(WordBuffer wordBuffer) {
        if (this.calendar != GREGORIAN) {
            wordBuffer.append(this.calendar.escape);
        }
        this.toString(wordBuffer, 0);
        return wordBuffer;
    }

    public String toString() {
        return this.toString(new WordBuffer()).toString();
    }

    public WordBuffer toString(WordBuffer wordBuffer) {
        return this.toString(wordBuffer, Options.getInstance().dateFormat);
    }

    private static DateFormat initNumericDateFormat() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        try {
            String string = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
            int n = string.indexOf("yyyy");
            if (n < 0) {
                dateFormat = new SimpleDateFormat(string.replaceAll("yy", "yyyy"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dateFormat;
    }

    public static void localeChangedNotify() {
        NUMERICDATEFORMAT = PointInTime.initNumericDateFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WordBuffer toString(WordBuffer wordBuffer, int n) {
        int n2 = this.year;
        boolean bl = false;
        if (this.calendar == GREGORIAN && this.year < 0) {
            n2 = 0 - this.year;
            bl = true;
        }
        if (n == 3) {
            if (this.calendar == GREGORIAN && this.isComplete()) {
                java.util.Calendar calendar = java.util.Calendar.getInstance();
                calendar.set(n2, this.month, this.day + 1);
                DateFormat dateFormat = NUMERICDATEFORMAT;
                synchronized (dateFormat) {
                    wordBuffer.append(NUMERICDATEFORMAT.format(calendar.getTime()));
                }
                if (bl) {
                    wordBuffer.append(" B.C.");
                }
                return wordBuffer;
            }
            n = 1;
        }
        if (!this.isValid()) {
            if (n != 0) {
                wordBuffer.append("?");
            }
            return wordBuffer;
        }
        if (this.year != Integer.MAX_VALUE) {
            if (this.month != Integer.MAX_VALUE) {
                if (this.day != Integer.MAX_VALUE) {
                    wordBuffer.append(this.day + 1);
                }
                wordBuffer.append(n == 0 ? this.calendar.getMonth(this.month) : this.calendar.getDisplayMonth(this.month, n == 1));
            }
            wordBuffer.append(n == 0 ? this.calendar.getYear(n2) : this.calendar.getDisplayYear(n2));
            if (n != 0 && this.calendar == JULIAN) {
                wordBuffer.append("(j)");
            }
            if (bl) {
                wordBuffer.append(" B.C.");
            }
        }
        return wordBuffer;
    }
}

