/*
 * Decompiled with CFR 0.152.
 */
package genj.help;

import genj.help.HelpWidget;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.view.ToolBar;
import genj.view.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class HelpView
extends View {
    public static final ImageIcon IMG = new ImageIcon(HelpView.class, "Help.png");
    private HelpWidget content = new HelpWidget();
    private Back back;
    private Forward forward;

    public HelpView() {
        super(new BorderLayout());
        this.add((Component)this.content, "Center");
        this.back = new Back();
        this.forward = new Forward();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (HelpView.this.content.getPage() == null) {
                    HelpView.this.content.setPage("overview");
                }
            }
        });
    }

    public void setPage(String string) {
        this.content.setPage(string);
    }

    public void populate(ToolBar toolBar) {
        toolBar.add(this.back);
        toolBar.add(this.forward);
    }

    private class Forward
    extends Action2 {
        private ArrayList<String> pages = new ArrayList();

        Forward() {
            this.setImage(new ImageIcon(this, "Forward.png"));
            this.setEnabled(false);
        }

        void clear() {
            this.pages.clear();
            this.setEnabled(false);
        }

        void push(String string) {
            this.pages.add(string);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpView.this.content.setPage(this.pages.remove(this.pages.size() - 1));
            this.setEnabled(!this.pages.isEmpty());
        }
    }

    private class Back
    extends Action2
    implements PropertyChangeListener {
        private ArrayList<String> urls = new ArrayList();

        public Back() {
            this.setImage(new ImageIcon(this, "Back.png"));
            HelpView.this.content.addPropertyChangeListener("url", this);
            this.setEnabled(false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = (String)propertyChangeEvent.getOldValue();
            if (string != null) {
                if (this.urls.isEmpty() || !this.urls.get(this.urls.size() - 1).equals(string)) {
                    this.urls.add(string);
                }
                this.setEnabled(true);
            }
            HelpView.this.forward.clear();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HelpView.this.content.getPage();
            String string2 = this.urls.get(this.urls.size() - 1);
            HelpView.this.content.removePropertyChangeListener("url", this);
            HelpView.this.content.setPage(string2);
            HelpView.this.content.addPropertyChangeListener("url", this);
            this.urls.remove(this.urls.size() - 1);
            this.setEnabled(!this.urls.isEmpty());
            if (string != null) {
                HelpView.this.forward.push(string);
            }
        }
    }
}

