/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.GedcomException;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.io.GedcomFormatException;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PropertyReader {
    protected static final Resources RESOURCES = Resources.get("genj.io");
    protected boolean useIndents = false;
    protected int lines = 0;
    protected String line = null;
    protected Collection collectXRefs;
    protected boolean isMerge = false;
    protected int level;
    protected String tag;
    protected String xref;
    protected String value;
    protected BufferedReader in;

    public PropertyReader(Reader reader, Collection collection, boolean bl) {
        this(new BufferedReader(reader), collection, bl);
    }

    public PropertyReader(BufferedReader bufferedReader, Collection collection, boolean bl) {
        this.in = bufferedReader;
        this.useIndents = bl;
        this.collectXRefs = collection;
    }

    public int getLines() {
        return this.lines;
    }

    public void read(Property property) throws IOException {
        this.read(property, -1);
    }

    public void read(Property property, int n) throws IOException {
        this.readProperties(property, 0, n);
        if (this.line != null) {
            this.line = null;
            this.in.reset();
        }
    }

    public void setMerge(boolean bl) {
        this.isMerge = bl;
    }

    protected void readProperties(Property property, int n, int n2) throws IOException {
        if (property instanceof MultiLineProperty) {
            MultiLineProperty.Collector collector = ((MultiLineProperty)((Object)property)).getLineCollector();
            while (this.readLine(false) && this.level >= n + 1 && collector.append(this.level - n, this.tag, this.value)) {
                this.line = null;
            }
            property.setValue(collector.getValue());
        }
        while (this.readLine(false)) {
            if (this.level < n + 1) {
                return;
            }
            this.line = null;
            if (this.level > n + 1) {
                this.trackBadLevel(this.level, property);
                for (int i = n; i < this.level - 1; ++i) {
                    property = property.addProperty("_TAG", "");
                }
            }
            int n3 = this.lines;
            Property property2 = this.addProperty(property, this.tag, this.value, n2);
            this.readProperties(property2, this.level, 0);
            if (property2 instanceof PropertyXRef) {
                this.link((PropertyXRef)property2, n3);
            }
            if (n2 < 0) continue;
            ++n2;
        }
        return;
    }

    protected Property addProperty(Property property, String string, String string2, int n) {
        Property property2;
        if (this.isMerge && (property2 = property.getProperty(string, false)) != null && property.getMetaProperty().getNested(string, false).isSingleton() && !(property2 instanceof PropertyXRef)) {
            property2.setValue(string2);
            return property2;
        }
        try {
            return property.addProperty(string, string2, n);
        }
        catch (GedcomException gedcomException) {
            Property property3 = property.addSimpleProperty(string, string2, n);
            this.trackBadProperty(property3, gedcomException.getMessage());
            return property3;
        }
    }

    protected boolean readLine(boolean bl) throws IOException {
        if (this.line == null) {
            this.in.mark(256);
            while (this.line == null) {
                this.line = this.in.readLine();
                if (this.line == null) {
                    return false;
                }
                ++this.lines;
                if (this.line.trim().length() != 0) continue;
                this.trackEmptyLine();
                this.line = null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.line, " \t");
            try {
                try {
                    if (this.useIndents) {
                        this.level = 0;
                        while (this.line.charAt(this.level) == ' ') {
                            ++this.level;
                        }
                        ++this.level;
                    } else {
                        this.level = Integer.parseInt(stringTokenizer.nextToken(), 10);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.emptyline"), this.lines);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.nonumber"), this.lines);
                }
                this.tag = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "_TAG";
                if (this.level == 0 && this.tag.startsWith("@")) {
                    if (!this.tag.endsWith("@") || this.tag.length() <= 2) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.invalidid"), this.lines);
                    }
                    this.xref = this.tag.substring(1, this.tag.length() - 1);
                    this.tag = stringTokenizer.nextToken();
                } else {
                    this.xref = "";
                }
                if (stringTokenizer.hasMoreElements()) {
                    this.value = stringTokenizer.nextToken("\n");
                    if (this.value.startsWith(" ")) {
                        this.value = this.value.substring(1);
                    }
                } else {
                    this.value = "";
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.cantparse"), this.lines);
            }
            this.tag = this.tag.intern();
        }
        if (bl) {
            this.line = null;
        }
        return true;
    }

    protected void link(PropertyXRef propertyXRef, int n) {
        if (this.collectXRefs != null) {
            this.collectXRefs.add(propertyXRef);
        } else {
            try {
                propertyXRef.link();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void trackEmptyLine() {
    }

    protected void trackBadLevel(int n, Property property) {
    }

    protected void trackBadProperty(Property property, String string) {
    }
}

