/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.Option;
import genj.option.OptionUI;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import swingx.tree.AbstractTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsWidget
extends JPanel {
    public static final ImageIcon IMAGE = new ImageIcon(OptionsWidget.class, "images/Options");
    private JTree tree;
    private Model model = new Model();
    private int widthOf1stColumn = 32;
    private String title;
    private DefaultTreeCellRenderer defaultRenderer;

    public OptionsWidget(String string) {
        this(string, null);
    }

    public OptionsWidget(String string, List<? extends Option> list) {
        this.title = string;
        this.tree = new JTree(this.model){

            public boolean isPathEditable(TreePath treePath) {
                return treePath.getLastPathComponent() instanceof Option;
            }
        };
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new Cell());
        this.tree.setCellEditor(new Cell());
        this.tree.setEditable(true);
        this.tree.setInvokesStopCellEditing(true);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.tree));
        if (list != null) {
            this.setOptions(list);
        }
    }

    @Override
    public void removeNotify() {
        this.stopEditing();
        super.removeNotify();
    }

    public void stopEditing() {
        this.tree.stopEditing();
    }

    public void setOptions(List<? extends Option> list) {
        this.stopEditing();
        this.tree.clearSelection();
        ArrayList<Option> arrayList = new ArrayList<Option>();
        for (Option object2 : list) {
            if (object2.getUI(this) == null) continue;
            arrayList.add(object2);
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Font font = this.tree.getFont();
        this.widthOf1stColumn = 0;
        for (Option option : arrayList) {
            this.widthOf1stColumn = Math.max(this.widthOf1stColumn, 4 + (int)Math.ceil(font.getStringBounds(option.getName(), fontRenderContext).getWidth()));
        }
        this.model.setOptions(arrayList);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.doLayout();
    }

    public void setUI(TreeUI treeUI) {
        super.setUI(treeUI);
        this.defaultRenderer = new DefaultTreeCellRenderer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends AbstractTreeModel {
        private List<String> categories = new ArrayList<String>();
        private Map<String, List<Option>> cat2options = new HashMap<String, List<Option>>();

        private Model() {
        }

        @Override
        protected Object getParent(Object object) {
            throw new IllegalArgumentException();
        }

        private List<Option> getCategory(String string) {
            List<Option> list;
            if (string == null) {
                string = OptionsWidget.this.title;
            }
            if ((list = this.cat2options.get(string)) == null) {
                list = new ArrayList<Option>();
                this.cat2options.put(string, list);
                this.categories.add(string);
            }
            return list;
        }

        private void setOptions(List<Option> list) {
            this.cat2options.clear();
            this.categories.clear();
            for (Option option : list) {
                List<Option> list2 = this.getCategory(option.getCategory());
                int n = Collections.binarySearch(list2, option, new Comparator<Option>(){

                    @Override
                    public int compare(Option option, Option option2) {
                        return option.getName().compareTo(option2.getName());
                    }
                });
                if (n >= 0) {
                    list2.add(option);
                    continue;
                }
                list2.add(-n - 1, option);
            }
            this.fireTreeStructureChanged(this, new Object[]{this}, null, null);
        }

        @Override
        public Object getRoot() {
            return this;
        }

        @Override
        public int getChildCount(Object object) {
            if (object == this) {
                return this.categories.size();
            }
            return this.getCategory((String)object).size();
        }

        @Override
        public boolean isLeaf(Object object) {
            return object instanceof Option;
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object == this) {
                return this.categories.get(n);
            }
            return this.getCategory((String)object).get(n);
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            throw new IllegalArgumentException();
        }
    }

    private class Cell
    extends AbstractCellEditor
    implements TreeCellRenderer,
    TreeCellEditor {
        private OptionUI optionUi;
        private JPanel panel = new JPanel(){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (keyStroke.getKeyCode() == 10) {
                    Cell.this.stopCellEditing();
                }
                if (keyStroke.getKeyCode() == 27) {
                    Cell.this.cancelCellEditing();
                }
                return true;
            }
        };
        private JLabel labelForName = new JLabel();
        private JLabel labelForValue = new JLabel();

        private Cell() {
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.labelForName, "West");
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (OptionsWidget.this.defaultRenderer != null) {
                if (bl) {
                    this.labelForName.setForeground(OptionsWidget.this.defaultRenderer.getTextSelectionColor());
                    this.labelForName.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundSelectionColor());
                    this.labelForValue.setForeground(OptionsWidget.this.defaultRenderer.getTextSelectionColor());
                    this.labelForValue.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundSelectionColor());
                } else {
                    this.labelForName.setForeground(OptionsWidget.this.defaultRenderer.getTextNonSelectionColor());
                    this.labelForName.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundNonSelectionColor());
                    this.labelForValue.setForeground(OptionsWidget.this.defaultRenderer.getTextNonSelectionColor());
                    this.labelForValue.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundNonSelectionColor());
                }
            }
            if (object instanceof Option) {
                return this.assemblePanel((Option)object, false);
            }
            if (this.panel.getComponentCount() > 1) {
                this.panel.remove(1);
            }
            this.labelForName.setText(object.toString());
            this.labelForName.setPreferredSize(null);
            return this.panel;
        }

        private JPanel assemblePanel(Option option, boolean bl) {
            JComponent jComponent;
            if (this.panel.getComponentCount() > 1) {
                this.panel.remove(1);
            }
            this.optionUi = option.getUI(OptionsWidget.this);
            this.labelForName.setText(option.getName());
            this.labelForName.setPreferredSize(new Dimension(OptionsWidget.this.widthOf1stColumn, 16));
            String string = this.optionUi.getTextRepresentation();
            if (string != null && !bl) {
                this.labelForValue.setText(string);
                jComponent = this.labelForValue;
            } else {
                jComponent = this.optionUi.getComponentRepresentation();
            }
            this.panel.add((Component)jComponent, "Center");
            this.panel.setToolTipText(option.getToolTip());
            return this.panel;
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return this.assemblePanel((Option)object, true);
        }

        public Object getCellEditorValue() {
            return null;
        }

        public void cancelCellEditing() {
            this.optionUi = null;
            super.cancelCellEditing();
        }

        public boolean stopCellEditing() {
            if (this.optionUi != null) {
                this.optionUi.endRepresentation();
            }
            return super.stopCellEditing();
        }
    }
}

