/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.option.Option;
import genj.option.PropertyOption;
import genj.print.PrintRegistry;
import genj.print.PrintRenderer;
import genj.renderer.DPI;
import genj.renderer.EmptyHintKey;
import genj.util.Dimension2d;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.WordBuffer;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrintTask
implements Printable,
Trackable {
    static final DocFlavor FLAVOR = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
    static final Resources RESOURCES = Resources.get(PrintTask.class);
    static final Logger LOG = Logger.getLogger("genj.print");
    private PrintService service;
    private PrintRenderer renderer;
    private int page = 0;
    private Throwable throwable;
    private String title;
    private PrintRegistry registry;
    private String progress;
    private PrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
    private Dimension pages;
    private double zoomx = 1.0;
    private double zoomy = 1.0;
    private boolean printEmpties = false;

    public PrintTask(String string, PrintRenderer printRenderer) throws PrintException {
        this.renderer = printRenderer;
        this.title = string;
        this.registry = PrintRegistry.get(printRenderer);
        PrintService printService = this.registry.get(this.getDefaultService());
        if (!printService.isDocFlavorSupported(FLAVOR)) {
            printService = this.getDefaultService();
        }
        this.setService(printService);
        this.attributes.add(new JobName("GenJ", null));
        this.registry.get(this.attributes);
        String string2 = EnvironmentChecker.getProperty("genj.print.file", null, "Print file output");
        if (string2 != null) {
            this.attributes.add(new Destination(new File(string2).toURI()));
        }
    }

    String getTitle() {
        return this.title;
    }

    protected PrintService getDefaultService() throws PrintException {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null) {
            if (printService.isDocFlavorSupported(FLAVOR)) {
                return printService;
            }
            LOG.info("Default print service not supported");
        } else {
            LOG.info("No default print service available (are you running CUPS?)");
        }
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(FLAVOR, null);
        if (printServiceArray.length == 0) {
            throw new PrintException("Couldn't find any suitable printer");
        }
        return printServiceArray[0];
    }

    protected PrintService[] getServices() {
        return PrintServiceLookup.lookupPrintServices(FLAVOR, null);
    }

    PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    void setService(PrintService printService) {
        this.service = printService;
        this.registry.put(this.service);
    }

    PrintService getService() {
        return this.service;
    }

    DPI getResolution() {
        return new DPI(72, 72);
    }

    Rectangle2D getPrintable() {
        OrientationRequested orientationRequested = (OrientationRequested)this.getAttribute(OrientationRequested.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.getAttribute(MediaPrintableArea.class);
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        if (orientationRequested == OrientationRequested.LANDSCAPE || orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
            Dimension2D dimension2D = this.getPageSize();
            ((Rectangle2D)float_).setRect(dimension2D.getWidth() - (double)mediaPrintableArea.getHeight(25400) - (double)mediaPrintableArea.getY(25400), mediaPrintableArea.getX(25400), mediaPrintableArea.getHeight(25400), mediaPrintableArea.getWidth(25400));
        } else {
            ((Rectangle2D)float_).setRect(mediaPrintableArea.getX(25400), mediaPrintableArea.getY(25400), mediaPrintableArea.getWidth(25400), mediaPrintableArea.getHeight(25400));
        }
        return float_;
    }

    Rectangle2D getPrintable(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getPrintable();
        return new Rectangle2D.Double(rectangle2D.getMinX() + rectangle2D2.getX(), rectangle2D.getMinY() + rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
    }

    Dimension2D getPageSize() {
        OrientationRequested orientationRequested = (OrientationRequested)this.getAttribute(OrientationRequested.class);
        Media media = (Media)this.getAttribute(Media.class);
        MediaSize mediaSize = null;
        if (media instanceof MediaSizeName) {
            mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
        }
        if (mediaSize == null) {
            try {
                mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media.getClass().getMethod("getStandardMedia", new Class[0]).invoke((Object)media, new Object[0]));
                LOG.fine("Got MediaSize " + mediaSize + " from " + media + ".getStandardMedia()");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (mediaSize == null) {
            LOG.warning("Need MediaSize, got unknown MediaSizeName, MediaTray or MediaName '" + media + "' - using A4");
            this.attributes.add(MediaSizeName.ISO_A4);
            mediaSize = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        }
        Dimension2d dimension2d = new Dimension2d();
        if (orientationRequested == OrientationRequested.LANDSCAPE || orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
            ((Dimension2D)dimension2d).setSize(mediaSize.getY(25400), mediaSize.getX(25400));
        } else {
            ((Dimension2D)dimension2d).setSize(mediaSize.getX(25400), mediaSize.getY(25400));
        }
        return dimension2d;
    }

    void setPages(Dimension dimension, boolean bl) {
        if (dimension.width == 0 || dimension.height == 0) {
            throw new IllegalArgumentException("0 not allowed");
        }
        this.pages = dimension;
        Rectangle2D rectangle2D = this.getPrintable();
        Dimension2D dimension2D = this.getSize();
        this.zoomx = (double)dimension.width * rectangle2D.getWidth() / dimension2D.getWidth();
        this.zoomy = (double)dimension.height * rectangle2D.getHeight() / dimension2D.getHeight();
        if (!bl) {
            if (this.zoomx > this.zoomy) {
                this.zoomx = this.zoomy;
            }
            if (this.zoomy > this.zoomx) {
                this.zoomy = this.zoomx;
            }
        }
    }

    boolean isPrintEmpties() {
        return this.printEmpties;
    }

    void setPrintEmpties(boolean bl) {
        this.printEmpties = bl;
    }

    void setZoom(double d) {
        this.zoomx = d;
        this.zoomy = d;
        this.pages = null;
    }

    Dimension2D getSize() {
        return this.renderer.getSize();
    }

    Dimension getPages() {
        if (this.pages != null) {
            return this.pages;
        }
        Rectangle2D rectangle2D = this.getPrintable();
        gj.awt.geom.Dimension2D dimension2D = this.renderer.getSize();
        return new Dimension((int)Math.ceil(dimension2D.getWidth() * this.zoomx / rectangle2D.getWidth()), (int)Math.ceil(dimension2D.getHeight() * this.zoomy / rectangle2D.getHeight()));
    }

    private String toString(PrintRequestAttributeSet printRequestAttributeSet) {
        WordBuffer wordBuffer = new WordBuffer(",");
        Attribute[] attributeArray = this.attributes.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            wordBuffer.append(attributeArray[i].getClass().getName() + "=" + attributeArray[i].toString());
        }
        return wordBuffer.toString();
    }

    private PrintRequestAttribute getAttribute(Class<? extends PrintRequestAttribute> clazz) {
        Object[] objectArray;
        Object object = this.attributes.get(clazz);
        if (object instanceof PrintRequestAttribute) {
            return (PrintRequestAttribute)object;
        }
        if (!Media.class.isAssignableFrom(clazz)) {
            this.getAttribute(Media.class);
        }
        if ((object = this.service.getDefaultAttributeValue(clazz)) == null) {
            LOG.finer("Couldn't find default PrintRequestAttribute for category " + clazz);
            object = this.service.getSupportedAttributeValues(clazz, null, this.attributes);
            if (object == null) {
                LOG.warning("Couldn't find supported PrintRequestAttribute for category " + clazz + " with " + this.toString(this.attributes));
            } else if (object.getClass().isArray()) {
                LOG.fine("Got PrintRequestAttribute values " + Arrays.toString((Object[])object) + " for category " + clazz);
                objectArray = (Object[])object;
                object = null;
                for (int i = 0; object == null && i < objectArray.length; ++i) {
                    if (objectArray[i] == null || !clazz.isAssignableFrom(objectArray[i].getClass())) continue;
                    object = objectArray[i];
                    break;
                }
            }
        }
        if (object == null && clazz == Media.class) {
            object = MediaSizeName.ISO_A4;
            LOG.warning("fallback media is " + object);
            this.attributes.add((Media)object);
        }
        if (object == null && clazz == MediaPrintableArea.class) {
            objectArray = this.getPageSize();
            object = new MediaPrintableArea(1.0f, 1.0f, (float)objectArray.getWidth() - 2.0f, (float)objectArray.getHeight() - 2.0f, 25400);
            LOG.warning("Using fallback MediaPrintableArea " + object);
        }
        if (object != null) {
            this.attributes.add((PrintRequestAttribute)object);
            LOG.fine("PrintRequestAttribute for category " + clazz + " is " + object + " with " + this.toString(this.attributes));
        } else {
            LOG.warning("Couldn't find any PrintRequestAttribute for category " + clazz + " with " + this.toString(this.attributes));
        }
        return (PrintRequestAttribute)object;
    }

    List<? extends Option> getOptions() {
        return PropertyOption.introspect(this.renderer);
    }

    @Override
    public void cancelTrackable() {
    }

    @Override
    public int getProgress() {
        return (int)((float)this.page / (float)(this.getPages().width * this.getPages().height) * 100.0f);
    }

    @Override
    public String getState() {
        return RESOURCES.getString("progress", this.page + 1, this.getPages().width * this.getPages().height);
    }

    void print() {
        this.registry.put(this.attributes);
        try {
            this.service.createPrintJob().print(new SimpleDoc(this, FLAVOR, null), this.attributes);
        }
        catch (PrintException printException) {
            LOG.log(Level.WARNING, "print failed", printException);
        }
        String string = EnvironmentChecker.getProperty("genj.print.file", null, "Print file output");
        if (string != null) {
            try {
                Desktop.getDesktop().open(new File(string));
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, "can't open " + string, throwable);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Dimension dimension = this.getPages();
        int n2 = n / dimension.width;
        int n3 = n % dimension.width;
        if (n3 >= dimension.width || n2 >= dimension.height) {
            return 1;
        }
        this.page = n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(DPI.KEY, this.getResolution());
        this.print((Graphics2D)graphics, n2, n3);
        return 0;
    }

    void print(Graphics2D graphics2D, int n, int n2) {
        DPI dPI = DPI.get(graphics2D);
        Rectangle2D rectangle2D = dPI.toPixel(this.getPrintable());
        graphics2D.translate(rectangle2D.getX() - (double)n2 * rectangle2D.getWidth(), rectangle2D.getY() - (double)n * rectangle2D.getHeight());
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)n2 * rectangle2D.getWidth(), (double)n * rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.clip(double_);
        graphics2D.scale(this.zoomx, this.zoomy);
        graphics2D.setRenderingHint(EmptyHintKey.KEY, true);
        this.renderer.render(graphics2D);
    }
}

