/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.util.ChangeSupport;
import genj.util.Resources;
import genj.util.swing.ChoiceWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScalingWidget
extends JPanel {
    private static final Pattern PERCENT = Pattern.compile("([0-9]{1,3})%");
    private static final Pattern DIM = Pattern.compile("([0-9]{1,2})x([0-9]{1,2})");
    private ChoiceWidget choice;
    private ChangeSupport changeSupport = new ChangeSupport(this);

    public ScalingWidget() {
        super(new BorderLayout());
        this.choice = new ChoiceWidget(new String[]{"1x1", "50%", "75%", "100%"}, "100%");
        this.choice.addChangeListener(new Validate());
        this.add((Component)new JLabel(Resources.get(this).getString("scaling")), "West");
        this.add((Component)this.choice, "Center");
    }

    public Object getValue() {
        String string = this.choice.getText().trim();
        Matcher matcher = PERCENT.matcher(string);
        if (matcher.find()) {
            return (double)Integer.parseInt(matcher.group(1)) * 0.01;
        }
        Matcher matcher2 = DIM.matcher(string);
        if (matcher2.find()) {
            return new Dimension(Integer.parseInt(matcher2.group(1)), Integer.parseInt(matcher2.group(2)));
        }
        return null;
    }

    void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private class Validate
    implements ChangeListener {
        private Validate() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = ScalingWidget.this.getValue();
            Color color = object != null ? null : Color.RED;
            ScalingWidget.this.choice.getEditor().getEditorComponent().setForeground(color);
            if (object != null) {
                ScalingWidget.this.changeSupport.fireChangeEvent();
            }
        }
    }
}

