/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySex;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintEditor;
import genj.renderer.DPI;
import genj.renderer.MediaRenderer;
import genj.util.Dimension2d;
import genj.util.EnvironmentChecker;
import genj.util.swing.ImageIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ParserDelegator;

public class BlueprintRenderer {
    private static final ImageIcon BROKEN = new ImageIcon(BlueprintEditor.class, "Broken.png");
    private static final Logger LOG = Logger.getLogger("genj.renderer");
    public static final String HINT_KEY_TXT = "txt";
    public static final String HINT_KEY_IMG = "img";
    public static final String HINT_KEY_SHORT = "short";
    public static final String HINT_VALUE_TRUE = "yes";
    public static final String HINT_VALUE_FALSE = "no";
    private static final int IMAGE_GAP = 4;
    private static final Stroke DEBUG_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f);
    private static final int PROP_IMAGE_WIDTH;
    private static final int PROP_IMAGE_HEIGHT;
    private static final Segment EMPTY_SEGMENT;
    private RootView root;
    private HTMLDocument doc = new MyHTMLDocument();
    private MyHTMLFactory factory = new MyHTMLFactory();
    private static DTD dtd;
    private Entity entity;
    private List<MyView> volatileViews = new ArrayList<MyView>(64);
    private List<View> tableViews = new ArrayList<View>(4);
    private boolean isDebug = false;
    private Graphics2D graphics;
    private Font plain;
    private Font bold;
    private Font italic;

    public BlueprintRenderer(Blueprint blueprint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html<body>");
        stringBuffer.append(blueprint.getHTML());
        stringBuffer.append("</body></html>");
        try {
            MyHTMLReader myHTMLReader = new MyHTMLReader(this.doc);
            new MyDocumentParser(DTD.getDTD("html32")).parse(new StringReader(stringBuffer.toString()), myHTMLReader, false);
            myHTMLReader.flush();
        }
        catch (Throwable throwable) {
            Logger.getLogger("genj.renderer").log(Level.WARNING, "can't parse blueprint " + blueprint, throwable);
        }
        this.root = new RootView(this.factory.create(this.doc.getDefaultRootElement()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics graphics, Entity entity, Rectangle rectangle) {
        this.entity = entity;
        this.graphics = (Graphics2D)graphics;
        Font font = graphics.getFont();
        if (!EnvironmentChecker.isMac()) {
            float f = (float)DPI.get(this.graphics).vertical() / 72.0f;
            font = font.deriveFont(f * font.getSize2D());
        }
        this.plain = font;
        this.bold = font.deriveFont(1);
        this.italic = font.deriveFont(2);
        try {
            for (MyView view : this.volatileViews) {
                view.invalidate();
            }
            for (View view : this.tableViews) {
                view.replace(0, 0, null);
            }
            this.root.setSize((float)rectangle.getWidth(), (float)rectangle.getHeight());
            Rectangle rectangle2 = graphics.getClipBounds();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            try {
                this.root.paint(graphics, rectangle);
            }
            finally {
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "can't render", throwable);
        }
    }

    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    protected Property getProperty(Entity entity, TagPath tagPath) {
        return entity.getProperty(tagPath);
    }

    static {
        new ParserDelegator();
        PROP_IMAGE_WIDTH = Indi.IMG_MALE.getIconWidth() + 4;
        PROP_IMAGE_HEIGHT = Indi.IMG_MALE.getIconHeight();
        EMPTY_SEGMENT = new Segment();
        dtd = null;
    }

    private class PropertyView
    extends MyView {
        private Map<String, String> attributes;
        private TagPath path;
        private Property cachedProperty;
        private Dimension2D cachedSize;

        PropertyView(Element element) {
            block4: {
                super(element);
                this.path = null;
                this.cachedProperty = null;
                this.cachedSize = null;
                this.attributes = new HashMap<String, String>();
                Object object = element.getAttributes().getAttributeNames();
                while (object.hasMoreElements()) {
                    Object obj = object.nextElement();
                    if (!(obj instanceof String)) continue;
                    this.attributes.put((String)obj, (String)element.getAttributes().getAttribute(obj));
                }
                object = element.getAttributes().getAttribute("path");
                if (object != null) {
                    try {
                        this.path = new TagPath((String)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!LOG.isLoggable(Level.FINER)) break block4;
                        LOG.log(Level.FINER, "got wrong path " + object);
                    }
                }
            }
        }

        private int getAttribute(String string, int n, int n2, int n3) {
            String string2 = this.attributes.get(string);
            if (string2 != null) {
                try {
                    return Math.max(n, Math.min(n2, Integer.parseInt(string2)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n3;
        }

        private Property getProperty() {
            if (this.cachedProperty != null) {
                return this.cachedProperty;
            }
            if (BlueprintRenderer.this.entity == null || this.path == null) {
                return null;
            }
            this.cachedProperty = BlueprintRenderer.this.getProperty(BlueprintRenderer.this.entity, this.path);
            return this.cachedProperty;
        }

        public void paint(Graphics graphics, Shape shape) {
            Object object;
            Property property = this.getProperty();
            if (property == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            Color color = super.getForeground();
            if (BlueprintRenderer.this.isDebug) {
                object = graphics2D.getStroke();
                graphics2D.setStroke(DEBUG_STROKE);
                graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 32));
                graphics2D.draw(rectangle);
                graphics2D.setStroke((Stroke)object);
            }
            object = graphics2D.getClip();
            graphics2D.clip(rectangle);
            graphics.setColor(color);
            graphics.setFont(super.getFont());
            this.render(property, graphics2D, rectangle);
            graphics.setClip((Shape)object);
        }

        private void render(Property property, Graphics2D graphics2D, Rectangle rectangle) {
            if (!(property instanceof Entity) && property instanceof MultiLineProperty) {
                this.render((MultiLineProperty)((Object)property), graphics2D, rectangle);
                return;
            }
            if (property instanceof PropertyFile || property instanceof PropertyBlob) {
                MediaRenderer.render(graphics2D, rectangle, property);
                return;
            }
            if (BlueprintRenderer.HINT_VALUE_TRUE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_IMG))) {
                this.render(property instanceof PropertyDate ? property.getParent().getImage(false) : property.getImage(false), graphics2D, rectangle);
            }
            if (!BlueprintRenderer.HINT_VALUE_FALSE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_TXT))) {
                this.render(this.getText(property), graphics2D, rectangle);
            }
        }

        private void render(MultiLineProperty multiLineProperty, Graphics2D graphics2D, Rectangle rectangle) {
            MultiLineProperty.Iterator iterator = multiLineProperty.getLineIterator();
            Graphics2D graphics2D2 = graphics2D;
            Font font = graphics2D.getFont();
            FontRenderContext fontRenderContext = graphics2D2.getFontRenderContext();
            float f = (float)rectangle.getX();
            float f2 = (float)rectangle.getY();
            do {
                String string = iterator.getValue();
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                graphics2D2.drawString(string, f, (f2 += lineMetrics.getHeight()) - lineMetrics.getDescent());
            } while (!((double)f2 > rectangle.getMaxY()) && iterator.next());
        }

        private void render(ImageIcon imageIcon, Graphics2D graphics2D, Rectangle rectangle) {
            if (rectangle.getHeight() == 0.0 || rectangle.getWidth() == 0.0) {
                return;
            }
            int n = imageIcon.getIconWidth();
            int n2 = graphics2D.getFontMetrics().getHeight();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(rectangle.getX(), rectangle.getY());
            if (n2 < imageIcon.getIconHeight()) {
                float f = (float)n2 / (float)imageIcon.getIconHeight();
                affineTransform.scale(f, f);
                n = (int)Math.ceil((float)n * f);
            }
            graphics2D.drawImage(imageIcon.getImage(), affineTransform, null);
            rectangle.x += n + 4;
            rectangle.width -= n + 4;
        }

        private String getText(Property property) {
            if (property instanceof Entity) {
                return this.getText((Entity)property);
            }
            if (property instanceof PropertyPlace) {
                return this.getText((PropertyPlace)property);
            }
            if (property instanceof PropertySex) {
                return this.getText((PropertySex)property);
            }
            return property.getDisplayValue();
        }

        private String getText(Entity entity) {
            return entity.getId();
        }

        private String getText(PropertySex propertySex) {
            String string;
            if (!this.attributes.containsKey(BlueprintRenderer.HINT_KEY_TXT)) {
                this.attributes.put(BlueprintRenderer.HINT_KEY_TXT, BlueprintRenderer.HINT_VALUE_FALSE);
            }
            if (!this.attributes.containsKey(BlueprintRenderer.HINT_KEY_IMG)) {
                this.attributes.put(BlueprintRenderer.HINT_KEY_IMG, BlueprintRenderer.HINT_VALUE_TRUE);
            }
            if ((string = propertySex.getDisplayValue()).length() > 0 && BlueprintRenderer.HINT_VALUE_TRUE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_SHORT))) {
                string = string.substring(0, 1);
            }
            return string;
        }

        private String getText(PropertyPlace propertyPlace) {
            return propertyPlace.format(this.attributes.get("format"));
        }

        protected Dimension2D getPreferredSpan() {
            if (this.cachedSize != null) {
                return this.cachedSize;
            }
            this.cachedSize = this.getSize();
            return this.cachedSize;
        }

        private Dimension2D getSize() {
            Property property = this.getProperty();
            if (property == null) {
                return new Dimension();
            }
            if (!(property instanceof Entity) && property instanceof MultiLineProperty) {
                return this.getSize((MultiLineProperty)((Object)property));
            }
            if (property instanceof PropertyFile || property instanceof PropertyBlob) {
                return MediaRenderer.getSize(property, this.getGraphics());
            }
            return this.getSize(property);
        }

        private Dimension2D getSize(Property property) {
            String string = this.getText(property);
            double d = 0.0;
            double d2 = 0.0;
            BlueprintRenderer.this.graphics.setFont(super.getFont());
            FontMetrics fontMetrics = BlueprintRenderer.this.graphics.getFontMetrics();
            if (!BlueprintRenderer.HINT_VALUE_FALSE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_TXT)) && string.length() > 0) {
                d += (double)fontMetrics.stringWidth(string);
                d2 = Math.max(d2, (double)(fontMetrics.getAscent() + fontMetrics.getDescent()));
            }
            if (BlueprintRenderer.HINT_VALUE_TRUE.equals(this.attributes.get(BlueprintRenderer.HINT_KEY_IMG))) {
                ImageIcon imageIcon = property.getImage(false);
                float f = fontMetrics.getHeight();
                float f2 = 1.0f;
                if (f < (float)imageIcon.getIconHeight()) {
                    f2 = f / (float)imageIcon.getIconHeight();
                }
                d += (double)((int)Math.ceil((float)imageIcon.getIconWidth() * f2) + 4);
                d2 = Math.max(d2, (double)fontMetrics.getHeight());
            }
            return new Dimension2d(d, d2);
        }

        private Dimension2D getSize(MultiLineProperty multiLineProperty) {
            BlueprintRenderer.this.graphics.setFont(super.getFont());
            FontMetrics fontMetrics = BlueprintRenderer.this.graphics.getFontMetrics();
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            MultiLineProperty.Iterator iterator = multiLineProperty.getLineIterator();
            do {
                ++n;
                d = Math.max(d, (double)fontMetrics.stringWidth(iterator.getValue()));
                d2 += (double)fontMetrics.getHeight();
            } while (iterator.next());
            return new Dimension2d(d, d2);
        }

        protected void invalidate() {
            this.cachedProperty = null;
            this.cachedSize = null;
            super.invalidate();
        }
    }

    private class MediaView
    extends MyView {
        private TagPath path2root;

        MediaView(Element element) {
            block3: {
                super(element);
                this.path2root = null;
                Object object = element.getAttributes().getAttribute("path");
                if (object != null) {
                    try {
                        this.path2root = new TagPath((String)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!LOG.isLoggable(Level.FINER)) break block3;
                        LOG.log(Level.FINER, "got wrong path " + object);
                    }
                }
            }
        }

        private Property getRoot() {
            Property property = null;
            if (this.path2root != null) {
                property = BlueprintRenderer.this.entity.getProperty(this.path2root);
            }
            return property != null ? property : BlueprintRenderer.this.entity;
        }

        protected Dimension2D getPreferredSpan() {
            Dimension dimension = MediaRenderer.getSize(this.getRoot(), BlueprintRenderer.this.graphics);
            if (BlueprintRenderer.this.isDebug && ((Dimension2D)dimension).getWidth() == 0.0 && ((Dimension2D)dimension).getHeight() == 0.0) {
                return BROKEN.getSizeInPoints(DPI.get(BlueprintRenderer.this.graphics));
            }
            return dimension;
        }

        public void paint(Graphics graphics, Shape shape) {
            Dimension dimension;
            Rectangle rectangle = shape.getBounds();
            if (BlueprintRenderer.this.isDebug && ((Dimension2D)(dimension = MediaRenderer.getSize(this.getRoot(), BlueprintRenderer.this.graphics))).getWidth() == 0.0 && ((Dimension2D)dimension).getHeight() == 0.0) {
                BROKEN.paintIcon(graphics, rectangle.x, rectangle.y);
                return;
            }
            MediaRenderer.render(graphics, rectangle, this.getRoot());
        }
    }

    private class I18NView
    extends MyView {
        private String txt;

        private I18NView(Element element) {
            super(element);
            this.txt = "?";
            Object object = element.getAttributes().getAttribute("tag");
            if (object != null) {
                this.txt = Gedcom.getName(object.toString());
            } else {
                object = element.getAttributes().getAttribute("entity");
                if (object != null) {
                    this.txt = Gedcom.getName(object.toString());
                }
            }
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics.setFont(this.getFont());
            graphics.setColor(this.getForeground());
            this.render(this.txt, (Graphics2D)graphics, rectangle);
        }

        protected Dimension2D getPreferredSpan() {
            FontMetrics fontMetrics = BlueprintRenderer.this.graphics.getFontMetrics(this.getFont());
            return new Dimension(fontMetrics.stringWidth(this.txt), fontMetrics.getAscent() + fontMetrics.getDescent());
        }
    }

    private class RootView
    extends View {
        private View view;
        private float width;
        private float height;

        RootView(View view) {
            super(null);
            this.view = view;
            view.setParent(this);
        }

        public float getPreferredSpan(int n) {
            throw new RuntimeException("getPreferredSpan() is not supported");
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            throw new RuntimeException("viewToModel() is not supported");
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            throw new RuntimeException("modelToView() is not supported");
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public void paint(Graphics graphics, Shape shape) {
            this.view.paint(graphics, shape);
        }

        public Document getDocument() {
            return BlueprintRenderer.this.doc;
        }

        public Graphics getGraphics() {
            return BlueprintRenderer.this.graphics;
        }

        public void setSize(float f, float f2) {
            this.width = f;
            this.height = f2;
            try {
                this.view.setSize(this.width, this.height);
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, "unexpected", throwable);
            }
        }

        public ViewFactory getViewFactory() {
            return BlueprintRenderer.this.factory;
        }
    }

    private abstract class MyView
    extends View {
        private Font font;
        private Color foreground;
        private Dimension2D preferredSpan;
        private int max;

        MyView(Element element) {
            super(element);
            this.font = null;
            this.foreground = null;
            this.preferredSpan = null;
            this.max = 0;
            try {
                this.max = Integer.parseInt((String)element.getAttributes().getAttribute("max"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            throw new RuntimeException("viewToModel() is not supported");
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            throw new RuntimeException("modelToView() is not supported");
        }

        public int getBreakWeight(int n, float f, float f2) {
            if (n == 1) {
                return 0;
            }
            if (f2 > this.getPreferredSpan(0)) {
                return 1000;
            }
            return 0;
        }

        public View breakView(int n, int n2, float f, float f2) {
            return this;
        }

        public float getPreferredSpan(int n) {
            if (this.preferredSpan == null) {
                this.preferredSpan = this.getPreferredSpan();
                if (this.max > 0) {
                    double d = BlueprintRenderer.this.root.width * (float)this.max / 100.0f;
                    if (this.preferredSpan.getWidth() > d) {
                        this.preferredSpan = new Dimension2d(d, this.preferredSpan.getHeight() * d / this.preferredSpan.getWidth());
                    }
                }
            }
            return (float)(n == 0 ? this.preferredSpan.getWidth() : this.preferredSpan.getHeight());
        }

        public float getMinimumSpan(int n) {
            return this.getPreferredSpan(n);
        }

        public float getMaximumSpan(int n) {
            return this.getPreferredSpan(n);
        }

        public float getAlignment(int n) {
            if (0 == n) {
                return super.getAlignment(n);
            }
            float f = (float)this.getPreferredSpan().getHeight();
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
            float f2 = fontMetrics.getHeight();
            float f3 = fontMetrics.getDescent();
            return (f2 - f3) / f;
        }

        public Graphics getGraphics() {
            BlueprintRenderer.this.graphics.setFont(this.getFont());
            return BlueprintRenderer.this.graphics;
        }

        protected Color getForeground() {
            if (this.foreground == null) {
                this.foreground = BlueprintRenderer.this.doc.getForeground(BlueprintRenderer.this.doc.getStyleSheet().getViewAttributes(this));
            }
            return this.foreground;
        }

        protected Font getFont() {
            if (this.font == null) {
                this.font = BlueprintRenderer.this.doc.getFont(BlueprintRenderer.this.doc.getStyleSheet().getViewAttributes(this));
            }
            return this.font;
        }

        protected abstract Dimension2D getPreferredSpan();

        protected void invalidate() {
            this.preferredSpan = null;
            this.font = null;
            super.preferenceChanged(this, true, true);
        }

        public ViewFactory getViewFactory() {
            return BlueprintRenderer.this.factory;
        }

        protected void render(String string, Graphics2D graphics2D, Rectangle rectangle) {
            if (string.length() == 0) {
                return;
            }
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, (float)rectangle.getX(), (float)rectangle.getY() + textLayout.getAscent());
        }
    }

    private class MyHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private MyHTMLFactory() {
        }

        public View create(Element element) {
            String string = element.getName();
            if ("prop".equals(string)) {
                PropertyView propertyView = new PropertyView(element);
                BlueprintRenderer.this.volatileViews.add(propertyView);
                return propertyView;
            }
            if ("name".equals(string) || "i18n".equals(string)) {
                return new I18NView(element);
            }
            if ("media".equals(string)) {
                MediaView mediaView = new MediaView(element);
                BlueprintRenderer.this.volatileViews.add(mediaView);
                return mediaView;
            }
            View view = super.create(element);
            if ("table".equals(element.getName())) {
                BlueprintRenderer.this.tableViews.add(view);
            }
            return view;
        }
    }

    private static class MyHTMLReader
    extends HTMLDocument.HTMLReader {
        private boolean skipContent;

        protected MyHTMLReader(HTMLDocument hTMLDocument) {
            HTMLDocument hTMLDocument2 = hTMLDocument;
            hTMLDocument2.getClass();
            super(hTMLDocument2, 0);
            this.skipContent = false;
        }

        protected void blockClose(HTML.Tag tag) {
            this.skipContent = true;
            super.blockClose(tag);
            this.skipContent = false;
        }

        protected void addContent(char[] cArray, int n, int n2, boolean bl) {
            if (!this.skipContent) {
                super.addContent(cArray, n, n2, bl);
            }
        }
    }

    private class MyDocumentParser
    extends DocumentParser {
        private MyDocumentParser(DTD dTD) {
            super(dTD);
            this.strict = true;
        }
    }

    private class MyHTMLDocument
    extends HTMLDocument {
        private MyHTMLDocument() {
        }

        public Font getFont(AttributeSet attributeSet) {
            Font font = BlueprintRenderer.this.plain;
            if (StyleConstants.isBold(attributeSet)) {
                font = BlueprintRenderer.this.bold;
            } else if (StyleConstants.isItalic(attributeSet)) {
                font = BlueprintRenderer.this.italic;
            }
            return font;
        }
    }
}

