/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.gedcom.Gedcom;
import genj.option.Option;
import genj.option.OptionProvider;
import genj.option.PropertyOption;
import genj.report.ReportLoader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
extends OptionProvider {
    private static Options instance = new Options();
    private int positions = 2;
    private int indentPerLevel = 5;
    private String birthSymbol = "*";
    private String baptismSymbol = "~";
    private String engagingSymbol = "o";
    private String marriageSymbol = "oo";
    private String divorceSymbol = "o|o";
    private String deathSymbol = "+";
    private String burialSymbol = "[]";
    private String occuSymbol = "=";
    private String resiSymbol = "^";
    private String childOfSymbol = "/";

    private String trim(String string, String string2) {
        if (string == null) {
            return string2;
        }
        string = string.trim();
        int n = string.length();
        if (string.length() == 0) {
            return string2;
        }
        if (!Character.isLetter(string.charAt(n - 1))) {
            return string;
        }
        return string + ' ';
    }

    public int getIndentPerLevel() {
        return this.indentPerLevel;
    }

    public void setIndentPerLevel(int n) {
        this.indentPerLevel = Math.max(2, n);
    }

    public int getPositions() {
        return this.positions;
    }

    public void setPositions(int n) {
        this.positions = Math.max(0, n);
    }

    public String getBirthSymbol() {
        return this.birthSymbol;
    }

    public void setBirthSymbol(String string) {
        this.birthSymbol = this.trim(string, "*");
    }

    public String getBaptismSymbol() {
        return this.baptismSymbol;
    }

    public void setBaptismSymbol(String string) {
        this.baptismSymbol = this.trim(string, "~");
    }

    public String getEngagingSymbol() {
        return this.engagingSymbol;
    }

    public void setEngagingSymbol(String string) {
        this.engagingSymbol = this.trim(string, "o");
    }

    public String getMarriageSymbol() {
        return this.marriageSymbol;
    }

    public void setMarriageSymbol(String string) {
        this.marriageSymbol = this.trim(string, "oo");
    }

    public String getDivorceSymbol() {
        return this.divorceSymbol;
    }

    public void setDivorceSymbol(String string) {
        this.divorceSymbol = this.trim(string, "o|o");
    }

    public String getDeathSymbol() {
        return this.deathSymbol;
    }

    public void setDeathSymbol(String string) {
        this.deathSymbol = this.trim(string, "+");
    }

    public String getBurialSymbol() {
        return this.burialSymbol;
    }

    public void setBurialSymbol(String string) {
        this.burialSymbol = this.trim(string, "[]");
    }

    public String getOccuSymbol() {
        return this.occuSymbol;
    }

    public void setOccuSymbol(String string) {
        this.occuSymbol = this.trim(string, "=");
    }

    public String getResiSymbol() {
        return this.resiSymbol;
    }

    public void setResiSymbol(String string) {
        this.resiSymbol = this.trim(string, "^");
    }

    public String getChildOfSymbol() {
        return this.childOfSymbol;
    }

    public void setChildOfSymbol(String string) {
        this.childOfSymbol = this.trim(string, "/");
    }

    public String getSymbol(String string) {
        if ("BIRT".equals(string)) {
            return this.getBirthSymbol();
        }
        if ("BAPM".equals(string)) {
            return this.getBaptismSymbol();
        }
        if ("ENGA".equals(string)) {
            return this.getEngagingSymbol();
        }
        if ("MARR".equals(string)) {
            return this.getMarriageSymbol();
        }
        if ("DIV".equals(string)) {
            return this.getDivorceSymbol();
        }
        if ("DEAT".equals(string)) {
            return this.getDeathSymbol();
        }
        if ("BURI".equals(string)) {
            return this.getBurialSymbol();
        }
        if ("OCCU".equals(string)) {
            return this.getOccuSymbol();
        }
        if ("RESI".equals(string)) {
            return this.getResiSymbol();
        }
        if ("FAMC".equals(string)) {
            return this.getChildOfSymbol();
        }
        return Gedcom.getName(string);
    }

    @Override
    public List<? extends Option> getOptions() {
        new Thread(new Runnable(){

            public void run() {
                ReportLoader.getInstance();
            }
        }).start();
        return PropertyOption.introspect(Options.getInstance());
    }

    public static Options getInstance() {
        return instance;
    }
}

