/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.report.Report;
import genj.report.ReportSelectionListener;
import genj.report.ReportView;
import genj.util.Registry;
import genj.util.Resources;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ReportList
extends JList {
    private Callback callback = new Callback();
    private ReportSelectionListener selectionListener = null;
    private Registry registry;
    private static final Resources RESOURCES = Resources.get(ReportView.class);
    private boolean byGroup;

    public ReportList(Report[] reportArray, boolean bl) {
        this.byGroup = bl;
        this.setReports(reportArray);
        this.setVisibleRowCount(3);
        this.getSelectionModel().setSelectionMode(0);
        this.setCellRenderer(this.callback);
        this.addListSelectionListener(this.callback);
    }

    public void setSelection(Report report) {
        if (report == null) {
            this.clearSelection();
        } else {
            this.setSelectedValue(report, true);
        }
    }

    public Report getSelection() {
        return (Report)this.getSelectedValue();
    }

    public void setSelectionListener(ReportSelectionListener reportSelectionListener) {
        this.selectionListener = reportSelectionListener;
    }

    public void setReports(Report[] reportArray) {
        this.setModel(new DefaultComboBoxModel<Report>(reportArray));
    }

    private class Callback
    extends DefaultListCellRenderer
    implements ListSelectionListener {
        private Callback() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Report report = (Report)object;
            this.setText(report.getName());
            this.setIcon(report.getIcon());
            return this;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Report report = (Report)ReportList.this.getSelectedValue();
            if (ReportList.this.selectionListener != null) {
                ReportList.this.selectionListener.valueChanged(report);
            }
        }
    }
}

