/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.option.OptionsWidget;
import genj.report.Report;
import genj.report.ReportDetail;
import genj.report.ReportList;
import genj.report.ReportLoader;
import genj.report.ReportSelectionListener;
import genj.report.ReportView;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

class ReportSelector
extends JPanel {
    private ActionListener listener;
    private static final ImageIcon imgReload = new ImageIcon(ReportView.class, "Reload");
    private ReportDetail detail = new ReportDetail();
    private ReportList list = new ReportList(ReportLoader.getInstance().getReports(), false);
    private OptionsWidget options = new OptionsWidget("");

    public ReportSelector() {
        super(new BorderLayout());
        final Resources resources = Resources.get(this);
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(resources.getString("title"), this.detail);
        jTabbedPane.add(resources.getString("report.options"), this.options);
        this.detail.setOpaque(false);
        this.detail.setPreferredSize(new Dimension(320, 200));
        this.options.setPreferredSize(new Dimension(320, 200));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(resources.getString("report.reports")));
        JButton jButton = new JButton(new ActionReload());
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(jButton);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.list), "West");
        this.add((Component)jTabbedPane, "Center");
        this.list.setVisibleRowCount(8);
        this.list.setSelectionListener(new ReportSelectionListener(){

            public void valueChanged(Report report) {
                ReportSelector.this.detail.setReport(report);
                if (report != null) {
                    jTabbedPane.setTitleAt(0, report.getName());
                    ReportSelector.this.options.setOptions(report.getOptions());
                } else {
                    jTabbedPane.setTitleAt(0, resources.getString("report.options"));
                    ReportSelector.this.options.setOptions(new ArrayList());
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1 && ReportSelector.this.listener != null) {
                    ReportSelector.this.listener.actionPerformed(new ActionEvent(ReportSelector.this, 0, "run"));
                }
            }
        });
        if (this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public void select(Report report) {
        if (report != null) {
            this.list.setSelection(report);
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    Report getReport() {
        this.options.stopEditing();
        return this.list.getSelection();
    }

    private class ActionReload
    extends Action2 {
        protected ActionReload() {
            this.setImage(imgReload);
            this.setTip(Resources.get(this), "report.reload.tip");
            this.setEnabled(!ReportLoader.getInstance().isReportsInClasspath());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ReportLoader.clear();
            Report[] reportArray = ReportLoader.getInstance().getReports();
            ReportSelector.this.list.setReports(reportArray);
        }
    }
}

