/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.IOException;
import java.io.InputStream;

public class MeteredInputStream
extends InputStream {
    private long meter = 0L;
    private long marked = -1L;
    private InputStream in;

    public MeteredInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public long getCount() {
        return this.meter;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int n) {
        this.in.mark(n);
        this.marked = this.meter;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        ++this.meter;
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        this.meter += (long)n3;
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        this.meter += (long)n;
        return n;
    }

    public synchronized void reset() throws IOException {
        if (this.marked < 0L) {
            throw new IOException("reset() without mark()");
        }
        this.in.reset();
        this.meter = this.marked;
    }

    public long skip(long l) throws IOException {
        int n = (int)super.skip(l);
        this.meter += (long)n;
        return n;
    }
}

