/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSet<KEY, REF> {
    private Map<KEY, Set<REF>> key2references = new HashMap<KEY, Set<REF>>();
    private int size = 0;

    public Set<REF> getReferences(KEY KEY) {
        if (KEY == null) {
            return new HashSet();
        }
        Set<REF> set = this.key2references.get(KEY);
        if (set == null) {
            return new HashSet();
        }
        return set;
    }

    public int getSize() {
        return this.size;
    }

    public int getSize(KEY KEY) {
        if (KEY == null) {
            return 0;
        }
        Set<REF> set = this.key2references.get(KEY);
        if (set == null) {
            return 0;
        }
        return set.size();
    }

    public boolean add(KEY KEY) {
        return this.add(KEY, null);
    }

    public boolean add(KEY KEY, REF REF) {
        if (KEY == null) {
            return false;
        }
        Set<REF> set = this.key2references.get(KEY);
        if (set == null) {
            set = new HashSet<REF>();
            this.key2references.put(KEY, set);
        }
        if (REF == null) {
            return false;
        }
        if (!set.add(REF)) {
            return false;
        }
        ++this.size;
        return true;
    }

    public boolean remove(KEY KEY, REF REF) {
        if (KEY == null) {
            return false;
        }
        Set<REF> set = this.key2references.get(KEY);
        if (set == null) {
            return false;
        }
        if (!set.remove(REF)) {
            return false;
        }
        --this.size;
        if (set.isEmpty()) {
            this.key2references.remove(KEY);
        }
        return true;
    }

    public List<KEY> getKeys() {
        return this.getKeys(null);
    }

    public List<KEY> getKeys(Comparator<Object> comparator) {
        ArrayList<KEY> arrayList = new ArrayList<KEY>(this.key2references.keySet());
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        } else {
            Collections.sort(arrayList, new Comparator<KEY>(){

                @Override
                public int compare(KEY KEY, KEY KEY2) {
                    return ReferenceSet.this.getSize(KEY) - ReferenceSet.this.getSize(KEY2);
                }
            });
        }
        return arrayList;
    }
}

