/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private static Map<String, Resources> instances = new HashMap<String, Resources>();
    private volatile Map<String, String> key2string;
    private List<String> keys;
    private String pkg;
    private WeakHashMap<String, MessageFormat> msgFormats = new WeakHashMap();

    public Resources() {
        this((InputStream)null);
    }

    public Resources(InputStream inputStream) {
        this.key2string = new HashMap<String, String>();
        this.keys = new ArrayList<String>(1000);
        if (inputStream != null) {
            try {
                this.load(inputStream);
            }
            catch (IOException iOException) {
                Logger.getLogger("genj.util").log(Level.FINE, "can't read resources", iOException);
            }
        }
    }

    public static Resources get(Object object) {
        return Resources.get(Resources.calcPackage(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources get(String string) {
        Map<String, Resources> map = instances;
        synchronized (map) {
            Resources resources = instances.get(string);
            if (resources == null) {
                resources = new Resources(string);
                instances.put(string, resources);
            }
            return resources;
        }
    }

    private static String calcPackage(Object object) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? "" : string.substring(0, n);
    }

    private String calcFile(String string, String string2, String string3) {
        String string4 = '/' + string.replace('.', '/') + "/resources";
        if (string2 != null) {
            string4 = string4 + '_' + string2;
            if (string3 != null) {
                string4 = string4 + '_' + string3;
            }
        }
        return string4 + ".properties";
    }

    private Resources(String string) {
        this.pkg = string;
    }

    public void load(InputStream inputStream) throws IOException {
        Resources.load(inputStream, this.keys, this.key2string);
    }

    private static String trim(String string) {
        char c;
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && ('*' == (c = string.charAt(n)) || Character.isWhitespace(c)); ++n) {
        }
        return n == 0 ? string : string.substring(n);
    }

    private static void load(InputStream inputStream, List<String> list, Map<String, String> map) throws IOException {
        if (inputStream == null) {
            throw new IOException("can't load resources from null");
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string2 = null;
            int n = 0;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                int n2;
                String string3 = Resources.trim(string);
                if (string3.length() == 0) {
                    string2 = null;
                    continue;
                }
                if (string2 != null) {
                    if (string3.charAt(0) == '+') {
                        map.put(string2, map.get(string2) + "\n" + Resources.breakify(string3.substring(1)));
                        continue;
                    }
                    if (string3.charAt(0) == '&') {
                        map.put(string2, map.get(string2) + Resources.breakify(string3.substring(1)));
                        continue;
                    }
                    if (string.indexOf(string3) > n) {
                        String string4 = map.get(string2);
                        if (!string4.endsWith(" ") && !string4.endsWith("\n")) {
                            string4 = string4 + " ";
                        }
                        map.put(string2, string4 + Resources.breakify(string3));
                        continue;
                    }
                }
                if ((n2 = string3.indexOf(61)) <= 0) continue;
                String string5 = string3.substring(0, n2).trim();
                if (!Character.isJavaIdentifierStart(string.charAt(0))) continue;
                String string6 = Resources.trim(string3.substring(n2 + 1));
                list.add(string5);
                string5 = string5.toLowerCase();
                map.put(string5, Resources.breakify(string6));
                string2 = string5;
                n = string.indexOf(string3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(unsupportedEncodingException.getMessage());
        }
    }

    private static String breakify(String string) {
        int n;
        while ((n = string.indexOf("\\n")) >= 0) {
            string = string.substring(0, n) + '\n' + string.substring(n + 2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getKey2String() {
        if (this.key2string != null) {
            return this.key2string;
        }
        Resources resources = this;
        synchronized (resources) {
            if (this.key2string != null) {
                return this.key2string;
            }
            Locale locale = Locale.getDefault();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList = new ArrayList<String>(100);
            try {
                Resources.load(this.getClass().getResourceAsStream(this.calcFile(this.pkg, null, null)), arrayList, hashMap);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Resources.load(this.getClass().getResourceAsStream(this.calcFile(this.pkg, locale.getLanguage(), null)), arrayList, hashMap);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Resources.load(this.getClass().getResourceAsStream(this.calcFile(this.pkg, locale.getLanguage(), locale.getCountry())), arrayList, hashMap);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.key2string = hashMap;
            this.keys = arrayList;
        }
        return this.key2string;
    }

    public boolean contains(String string) {
        return this.getString(string, false) != null;
    }

    public String getString(String string, boolean bl) {
        String string2 = this.getKey2String().get(string.toLowerCase());
        if (string2 == null && bl) {
            string2 = string;
        }
        return string2;
    }

    public String getString(String string) {
        return this.getString(string, true);
    }

    public String getString(String string, Object ... objectArray) {
        MessageFormat messageFormat = this.msgFormats.get(string);
        if (messageFormat == null) {
            String string2 = this.getString(string, false);
            if (string2 == null) {
                return string;
            }
            messageFormat = Resources.getMessageFormat(string2);
            this.msgFormats.put(string, messageFormat);
        }
        return messageFormat.format(objectArray);
    }

    public static MessageFormat getMessageFormat(String string) {
        if (string.indexOf(39) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append('\'');
            }
            string = stringBuffer.toString();
        }
        return new MessageFormat(string);
    }

    public List<String> getKeys() {
        this.getKey2String();
        return this.keys;
    }
}

