/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceWidget
extends JComboBox {
    private boolean isTemplate = false;
    private Model model = new Model();
    private boolean isIgnoreCase = false;
    private ChangeSupport changeSupport = new ChangeSupport(this){

        public void fireChangeEvent() {
            ChoiceWidget.this.isTemplate = false;
            super.fireChangeEvent();
        }
    };
    private AutoCompleteSupport autoComplete;

    public ChoiceWidget() {
        this(new Object[0], null);
    }

    public ChoiceWidget(List<?> list) {
        this(list.toArray(), null);
    }

    public ChoiceWidget(Object[] objectArray, Object object) {
        this.setEditable(true);
        this.setMaximumRowCount(8);
        this.setModel(this.model);
        this.model.setValues(objectArray);
        this.setAlignmentX(0.0f);
        this.setSelectedItem(object);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void setValues(List<?> list) {
        this.setValues(list.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] objectArray) {
        try {
            this.autoComplete.disable();
            this.model.setValues(objectArray);
        }
        finally {
            this.autoComplete.enable();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.min(128, dimension.width);
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, super.getPreferredSize().height);
    }

    public void setSelectAllOnFocus(boolean bl) {
    }

    public void setTemplate(boolean bl) {
        this.isTemplate = bl;
    }

    public String getText() {
        if (this.isTemplate) {
            return "";
        }
        if (this.isEditable()) {
            return this.getEditor().getItem().toString();
        }
        return super.getSelectedItem().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        if (!this.isEditable) {
            throw new IllegalArgumentException("setText && !isEditable n/a");
        }
        this.model.setSelectedItem(null);
        try {
            this.autoComplete.disable();
            try {
                JTextField jTextField = this.getTextEditor();
                jTextField.setText(string);
                jTextField.setCaretPosition(0);
            }
            catch (Throwable throwable) {
                try {
                    PlainDocument plainDocument = new PlainDocument(new StringContent(255));
                    plainDocument.insertString(0, string, null);
                    this.getTextEditor().setDocument(plainDocument);
                }
                catch (Throwable throwable2) {
                    Logger.getLogger("genj.util.swing").log(Level.FINE, "Couldn't retry " + this.getTextEditor().getClass() + ".setText(" + string + ")", throwable2);
                    Logger.getLogger("genj.util.swing").log(Level.WARNING, "Couldn't call " + this.getTextEditor().getClass() + ".setText(" + string + ") - giving up", throwable);
                }
            }
        }
        finally {
            this.autoComplete.enable();
        }
    }

    public JTextField getTextEditor() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    public void setIgnoreCase(boolean bl) {
        this.isIgnoreCase = bl;
    }

    @Override
    public void setPopupVisible(boolean bl) {
        super.setPopupVisible(bl);
        if (bl) {
            String string = this.getText();
            for (int i = 0; i < this.getItemCount(); ++i) {
                String string2 = this.getItemAt(i).toString();
                if (!string2.regionMatches(this.isIgnoreCase, 0, string, 0, string.length())) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.isEditable()) {
            this.getEditor().getEditorComponent().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isEditable()) {
            return this.getEditor().getEditorComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void setEditor(final ComboBoxEditor comboBoxEditor) {
        if (!(comboBoxEditor.getEditorComponent() instanceof JTextField)) {
            throw new IllegalArgumentException("Only JTextEditor editor components are allowed");
        }
        ((JTextField)comboBoxEditor.getEditorComponent()).setColumns(4);
        super.setEditor(new ComboBoxEditor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setItem(Object object) {
                try {
                    ChoiceWidget.this.autoComplete.disable();
                    comboBoxEditor.setItem(object);
                }
                finally {
                    ChoiceWidget.this.autoComplete.enable();
                }
            }

            public void selectAll() {
                comboBoxEditor.selectAll();
            }

            public void removeActionListener(ActionListener actionListener) {
                comboBoxEditor.removeActionListener(actionListener);
            }

            public Object getItem() {
                return comboBoxEditor.getItem();
            }

            public Component getEditorComponent() {
                return comboBoxEditor.getEditorComponent();
            }

            public void addActionListener(ActionListener actionListener) {
                comboBoxEditor.addActionListener(actionListener);
            }
        });
        if (this.autoComplete == null) {
            this.autoComplete = new AutoCompleteSupport();
        }
        this.autoComplete.attach(this.getTextEditor());
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.getEditor().addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.getEditor().removeActionListener(actionListener);
    }

    private class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private Object[] values = new Object[0];
        private Object selection = null;

        private Model() {
        }

        private void setValues(Object[] objectArray) {
            this.selection = null;
            if (this.values.length > 0) {
                this.fireIntervalRemoved(this, 0, this.values.length - 1);
            }
            this.values = objectArray;
            if (this.values.length > 0) {
                this.fireIntervalAdded(this, 0, this.values.length - 1);
            }
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        private String setSelectedPrefix(String string) {
            for (int i = 0; i < this.values.length; ++i) {
                String string2 = this.values[i].toString();
                if (!string2.regionMatches(ChoiceWidget.this.isIgnoreCase, 0, string, 0, string.length())) continue;
                this.setSelectedItem(string2);
                return string2;
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedItem(Object object) {
            this.selection = object;
            try {
                ChoiceWidget.this.autoComplete.disable();
                ChoiceWidget.this.getEditor().setItem(this.selection);
            }
            finally {
                ChoiceWidget.this.autoComplete.enable();
            }
            ChoiceWidget.this.fireItemStateChanged(new ItemEvent(ChoiceWidget.this, 701, this.selection, 1));
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getElementAt(int n) {
            return this.values[n];
        }

        public int getSize() {
            return this.values.length;
        }
    }

    private class AutoCompleteSupport
    extends KeyAdapter
    implements DocumentListener,
    ActionListener,
    FocusListener,
    PropertyChangeListener {
        private JTextField text;
        private Timer timer = new Timer(250, this);
        private boolean enabled = true;

        private AutoCompleteSupport() {
            this.timer.setRepeats(false);
        }

        private void disable() {
            this.enabled = false;
            this.timer.stop();
        }

        private void enable() {
            this.enabled = true;
        }

        private void attach(JTextField jTextField) {
            if (this.text != null) {
                this.text.getDocument().removeDocumentListener(this);
                this.text.removeFocusListener(this);
                this.text.removeKeyListener(this);
                this.text.removePropertyChangeListener(this);
            }
            this.text = jTextField;
            this.text.getDocument().addDocumentListener(this);
            this.text.addFocusListener(this);
            this.text.addKeyListener(this);
            this.text.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(this);
                ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (this.enabled && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (this.enabled && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ChoiceWidget.this.changeSupport.fireChangeEvent();
            if (this.enabled && ChoiceWidget.this.isEditable()) {
                this.timer.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.text.getText();
            if (string.length() == 0) {
                return;
            }
            int n = this.text.getCaretPosition();
            String string2 = ChoiceWidget.this.model.setSelectedPrefix(string);
            if (string2.length() == 0) {
                ChoiceWidget.this.hidePopup();
                return;
            }
            try {
                this.disable();
                this.text.setText(string);
            }
            finally {
                this.enable();
            }
            this.text.setCaretPosition(n);
            if (string2.length() >= string.length() && ChoiceWidget.this.isShowing()) {
                ChoiceWidget.this.showPopup();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.text.getDocument() != null) {
                this.text.setCaretPosition(this.text.getDocument().getLength());
                this.text.moveCaretPosition(0);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && ChoiceWidget.this.isPopupVisible()) {
                ChoiceWidget.this.model.setSelectedItem(ChoiceWidget.this.model.getSelectedItem());
                ChoiceWidget.this.setPopupVisible(false);
            }
        }
    }
}

