/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorsWidget
extends JPanel {
    private ChangeSupport changes = new ChangeSupport(this);
    private JColorChooser chooser = new JColorChooser();
    private Model model = new Model();

    public ColorsWidget() {
        super(new BorderLayout());
        this.chooser.setPreviewPanel(new JPanel());
        final JList<Object> jList = new JList<Object>(this.model);
        jList.setSelectionMode(0);
        jList.setCellRenderer(new Renderer());
        this.add((Component)new JScrollPane(jList), "Center");
        this.add((Component)this.chooser, "South");
        jList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = jList.getSelectedIndex();
                if (n >= 0) {
                    ColorsWidget.this.changes.mute();
                    try {
                        ColorsWidget.this.chooser.setColor(((ColorsWidget)ColorsWidget.this).model.getItemAt((int)n).color);
                    }
                    finally {
                        ColorsWidget.this.changes.unmute();
                    }
                }
            }
        });
        this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jList.getSelectedIndex();
                if (n >= 0) {
                    ColorsWidget.this.model.setColor(n, ColorsWidget.this.chooser.getColor());
                    ColorsWidget.this.changes.fireChangeEvent();
                }
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changes.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changes.removeChangeListener(changeListener);
    }

    public void removeAllColors() {
        this.model.clear();
    }

    public Color getColor(String string) {
        return this.model.getItem((String)string).color;
    }

    public Map<String, Color> getColors() {
        return this.model.colors();
    }

    public void addColor(String string, String string2, Color color) {
        this.model.add(new Item(string, string2, color));
    }

    private class Renderer
    extends DefaultListCellRenderer
    implements Icon {
        private int dim = 8;
        private Color color;

        private Renderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(2);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Item item = (Item)object;
            super.getListCellRendererComponent((JList<?>)jList, item.name, n, bl, bl2);
            this.setIcon(this);
            this.color = item.color;
            return this;
        }

        public int getIconHeight() {
            return this.dim;
        }

        public int getIconWidth() {
            return this.dim;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.dim, this.dim);
            graphics.setColor(this.getForeground());
            graphics.drawRect(n, n2, this.dim, this.dim);
        }
    }

    private class Item {
        String key;
        String name;
        Color color;

        Item(String string, String string2, Color color) {
            this.key = string;
            this.name = string2;
            this.color = color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends AbstractListModel {
        private List<Item> items = new ArrayList<Item>();

        private Model() {
        }

        Map<String, Color> colors() {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            for (Item item : this.items) {
                hashMap.put(item.key, item.color);
            }
            return hashMap;
        }

        void clear() {
            int n = this.items.size();
            for (int i = n - 1; i >= 0; --i) {
                this.items.remove(i);
            }
            this.fireIntervalRemoved(this, 0, n);
        }

        void add(Item item) {
            this.items.add(item);
            this.fireIntervalAdded(this, this.items.size() - 1, this.items.size());
        }

        void setColor(int n, Color color) {
            this.getItemAt((int)n).color = color;
            this.fireContentsChanged(this, n, n);
        }

        Item getItem(String string) {
            for (Item item : this.items) {
                if (!item.key.equals(string)) continue;
                return item;
            }
            throw new IllegalArgumentException("key for unknown color");
        }

        Item getItemAt(int n) {
            return this.items.get(n);
        }

        @Override
        public Object getElementAt(int n) {
            return this.items.get(n);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }
    }
}

