/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import genj.util.EnvironmentChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

public class FontChooser
extends JPanel {
    private static String[] families = null;
    private JComboBox fonts;
    private JTextField size;
    private ChangeSupport changes = new ChangeSupport(this);
    private static final boolean isRenderWithFont = null == EnvironmentChecker.getProperty("genj.debug.fontproblems", null, "supress font usage in font-selection-list");

    public FontChooser() {
        this.fonts = new JComboBox<Font>(FontChooser.getAllFonts());
        this.fonts.setEditable(false);
        this.fonts.setRenderer(new Renderer());
        this.size = new JTextField(3);
        this.fonts.addActionListener(this.changes);
        this.size.getDocument().addDocumentListener(this.changes);
        this.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fonts, "Center");
        this.add((Component)this.size, "East");
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        return dimension;
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            this.fonts.setSelectedIndex(-1);
            this.size.setText("");
            return;
        }
        String string = font.getFamily();
        Font[] fontArray = FontChooser.getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            if (!fontArray[i].getFamily().equals(string)) continue;
            this.fonts.setSelectedIndex(i);
            break;
        }
        this.size.setText("" + font.getSize());
    }

    public Font getSelectedFont() {
        Font font = (Font)this.fonts.getSelectedItem();
        if (font == null) {
            return null;
        }
        return font.deriveFont((float)this.getSelectedFontSize());
    }

    private int getSelectedFontSize() {
        int n = 10;
        try {
            n = Integer.parseInt(this.size.getText());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Math.max(2, n);
    }

    private static Font[] getAllFonts() {
        if (families == null) {
            families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        Font[] fontArray = new Font[families.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = new Font(families[i], 0, 12);
        }
        return fontArray;
    }

    public static void main(String[] stringArray) {
        System.out.println("Running font test");
        Font[] fontArray = FontChooser.getAllFonts();
        System.out.println("Found " + fontArray.length + " fonts");
        String string = "GenealogyJ";
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        for (int i = 0; i < fontArray.length; ++i) {
            Font font = fontArray[i];
            System.out.println("Testing font " + font + "...");
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            lineMetrics.getAscent();
            lineMetrics.getBaselineIndex();
            lineMetrics.getDescent();
            lineMetrics.getHeight();
            lineMetrics.getLeading();
            lineMetrics.getStrikethroughOffset();
            lineMetrics.getUnderlineOffset();
            lineMetrics.getUnderlineThickness();
            System.out.println("OK");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changes.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changes.removeChangeListener(changeListener);
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Font) {
                Font font = (Font)object;
                super.getListCellRendererComponent((JList<?>)jList, font.getFamily(), n, bl, bl2);
                if (isRenderWithFont) {
                    this.setFont(font);
                }
            } else {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
            return this;
        }
    }
}

