/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.renderer.DPI;
import genj.util.ByteArray;
import genj.util.Dimension2d;
import genj.util.ImageSniffer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageIcon
extends javax.swing.ImageIcon {
    private static final ImageFilter GRAYSCALE_FILTER = new BufferedImageFilter(new GrayscaleFilter());
    private DPI dpi = null;
    private Map<Object, ImageIcon> overlays = new WeakHashMap<Object, ImageIcon>();

    public ImageIcon(Image image) {
        super(image);
    }

    public ImageIcon(Icon icon) {
        if (icon instanceof javax.swing.ImageIcon) {
            this.setImage(((javax.swing.ImageIcon)icon).getImage());
        } else {
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
            this.setImage(bufferedImage);
        }
    }

    public ImageIcon(String string, byte[] byArray) {
        super(byArray);
        if (this.getImageLoadStatus() != 8) {
            throw new RuntimeException("load status incomplete");
        }
        if (this.getIconHeight() < 0 || this.getIconWidth() < 0) {
            throw new RuntimeException("image with invalid width/height");
        }
        this.setDescription(string);
        this.dpi = new ImageSniffer(new ByteArrayInputStream(byArray)).getDPI();
    }

    public ImageIcon(Object object, String string) {
        this(object.getClass(), string);
    }

    private static String patchPNG(String string) {
        return string.indexOf(46) < 0 ? string + ".png" : string;
    }

    public ImageIcon(Class<?> clazz, String string) {
        this(clazz.getName() + '#' + string, clazz.getResourceAsStream(ImageIcon.patchPNG(string)), true);
    }

    public ImageIcon(String string, InputStream inputStream) {
        this(string, inputStream, false);
    }

    private ImageIcon(String string, InputStream inputStream, boolean bl) {
        this(string, ImageIcon.read(string, inputStream, bl));
    }

    public DPI getResolution() {
        return this.dpi;
    }

    public Dimension2D getSizeInInches() {
        if (this.dpi == null) {
            return null;
        }
        return new Dimension2d((double)this.getIconWidth() / (double)this.dpi.horizontal(), (double)this.getIconHeight() / (double)this.dpi.vertical());
    }

    public Dimension getSizeInPoints(DPI dPI) {
        Dimension2D dimension2D = this.getSizeInInches();
        if (dimension2D == null) {
            return new Dimension(this.getIconWidth(), this.getIconHeight());
        }
        return new Dimension((int)(dimension2D.getWidth() * (double)dPI.horizontal()), (int)(dimension2D.getHeight() * (double)dPI.vertical()));
    }

    public ImageIcon paintIcon(Graphics graphics, int n, int n2) {
        super.paintIcon(null, graphics, n, n2);
        return this;
    }

    private static byte[] read(String string, InputStream inputStream, boolean bl) {
        if (inputStream == null) {
            throw new IllegalArgumentException("no stream for " + string);
        }
        try {
            byte[] byArray = new ByteArray(inputStream).getBytes();
            return byArray;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't read " + string + ": " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("interrupted while reading " + string);
        }
        finally {
            if (bl) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ImageIcon getGrayedOut() {
        ImageIcon imageIcon = this.overlays.get("grayedout");
        if (imageIcon != null) {
            return imageIcon;
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getImage().getSource(), GRAYSCALE_FILTER);
        Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        imageIcon = new ImageIcon(image);
        imageIcon.dpi = this.dpi;
        imageIcon.setDescription(this.getDescription());
        this.overlays.put("grayedout", imageIcon);
        return imageIcon;
    }

    public ImageIcon getTransparent(final int n) {
        ImageIcon imageIcon = this.overlays.get(Integer.toString(n));
        if (imageIcon != null) {
            return imageIcon;
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("!(0<=threshold<=255)");
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getImage().getSource(), new RGBImageFilter(){

            public int filterRGB(int n5, int n2, int n3) {
                int n4 = n3 >> 24 & 0xFF;
                n4 = n4 * n / 255;
                return n3 & 0xFFFFFF | n4 << 24;
            }
        });
        imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
        imageIcon.dpi = this.dpi;
        imageIcon.setDescription(this.getDescription());
        this.overlays.put(Integer.toString(n), imageIcon);
        return imageIcon;
    }

    public ImageIcon getOverLayed(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = this.overlays.get(imageIcon);
        if (imageIcon2 != null) {
            return imageIcon2;
        }
        int n = Math.max(this.getIconHeight(), imageIcon.getIconHeight());
        int n2 = Math.max(this.getIconWidth(), imageIcon.getIconWidth());
        Image image = this.getImage();
        Image image2 = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n2, n);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.drawImage(image2, 0, 0, null);
        graphics2D.dispose();
        imageIcon2 = new ImageIcon(bufferedImage);
        imageIcon2.dpi = this.dpi;
        imageIcon2.setDescription(this.getDescription());
        this.overlays.put(imageIcon, imageIcon2);
        return imageIcon2;
    }

    private static class GrayscaleFilter
    implements BufferedImageOp {
        private GrayscaleFilter() {
        }

        public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
            if (colorModel == null) {
                colorModel = bufferedImage.getColorModel();
            }
            return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        }

        public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
            if (point2D2 == null) {
                point2D2 = new Point2D.Double();
            }
            point2D2.setLocation(point2D.getX(), point2D.getY());
            return point2D2;
        }

        public RenderingHints getRenderingHints() {
            return null;
        }

        public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = bufferedImage.getType();
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (bufferedImage2 == null) {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            int[] nArray = new int[n];
            for (int i = 0; i < n2; ++i) {
                int n4;
                if (n3 == 2) {
                    writableRaster.getDataElements(0, i, n, 1, nArray);
                    for (n4 = 0; n4 < n; ++n4) {
                        nArray[n4] = this.filterRGB(n4, i, nArray[n4]);
                    }
                    writableRaster2.setDataElements(0, i, n, 1, nArray);
                    continue;
                }
                bufferedImage.getRGB(0, i, n, 1, nArray, 0, n);
                for (n4 = 0; n4 < n; ++n4) {
                    nArray[n4] = this.filterRGB(n4, i, nArray[n4]);
                }
                bufferedImage2.setRGB(0, i, n, 1, nArray, 0, n);
            }
            return bufferedImage2;
        }

        private int filterRGB(int n, int n2, int n3) {
            int n4 = n3 & 0xFF000000;
            int n5 = n3 >> 16 & 0xFF;
            int n6 = n3 >> 8 & 0xFF;
            int n7 = n3 & 0xFF;
            n3 = n5 * 77 + n6 * 151 + n7 * 28 >> 8;
            return n4 | n3 << 16 | n3 << 8 | n3;
        }
    }
}

