/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MacAdapter {
    private static Logger logger = Logger.getLogger(MacAdapter.class.getName());
    private static MacAdapter adapter;

    public abstract void install(String var1);

    public abstract boolean isInstalled();

    public abstract void setPreferencesListener(ActionListener var1);

    public abstract void setAboutListener(ActionListener var1);

    public abstract void setQuitListener(ActionListener var1);

    private static void unexpected(Throwable throwable) {
        logger.log(Level.WARNING, "unexpected failure", throwable);
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public static MacAdapter getInstance() {
        if (adapter == null) {
            if (MacAdapter.isMac()) {
                try {
                    adapter = new Real();
                }
                catch (Throwable throwable) {
                    MacAdapter.unexpected(throwable);
                    adapter = new Dummy();
                }
            } else {
                adapter = new Dummy();
            }
        }
        return adapter;
    }

    private static class Real
    extends MacAdapter {
        private ActionListener preferencesAction;
        private ActionListener aboutAction;
        private ActionListener quitAction;
        private Application application;

        private Real() {
        }

        public void install(String string) {
            System.setProperty("apple.awt.showGrowBox", "false");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
            try {
                this.application = new Application();
                this.application.addApplicationListener(new ApplicationListener(){

                    public void handlePreferences(ApplicationEvent applicationEvent) {
                        Real.this.perform(Real.this.preferencesAction);
                        applicationEvent.setHandled(true);
                    }

                    public void handleAbout(ApplicationEvent applicationEvent) {
                        Real.this.perform(Real.this.aboutAction);
                        applicationEvent.setHandled(true);
                    }

                    public void handleQuit(ApplicationEvent applicationEvent) {
                        Real.this.perform(Real.this.quitAction);
                        applicationEvent.setHandled(false);
                    }

                    public void handleOpenApplication(ApplicationEvent applicationEvent) {
                    }

                    public void handleOpenFile(ApplicationEvent applicationEvent) {
                    }

                    public void handlePrintFile(ApplicationEvent applicationEvent) {
                    }

                    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
                    }
                });
            }
            catch (Throwable throwable) {
                MacAdapter.unexpected(throwable);
            }
        }

        public boolean isInstalled() {
            return this.application != null;
        }

        private void checkInstalled() {
            if (this.application == null) {
                throw new Error("not installed");
            }
        }

        public void setPreferencesListener(ActionListener actionListener) {
            this.checkInstalled();
            this.preferencesAction = actionListener;
            try {
                this.application.setEnabledPreferencesMenu(true);
            }
            catch (Throwable throwable) {
                MacAdapter.unexpected(throwable);
            }
        }

        public void setAboutListener(ActionListener actionListener) {
            this.checkInstalled();
            this.aboutAction = actionListener;
            try {
                this.application.setEnabledAboutMenu(true);
            }
            catch (Throwable throwable) {
                MacAdapter.unexpected(throwable);
            }
        }

        public void setQuitListener(ActionListener actionListener) {
            this.checkInstalled();
            this.quitAction = actionListener;
        }

        private void perform(ActionListener actionListener) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, "mac"));
        }
    }

    private static class Dummy
    extends MacAdapter {
        private Dummy() {
        }

        public void install(String string) {
        }

        public boolean isInstalled() {
            return false;
        }

        public void setPreferencesListener(ActionListener actionListener) {
        }

        public void setAboutListener(ActionListener actionListener) {
        }

        public void setQuitListener(ActionListener actionListener) {
        }
    }
}

