/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.Trackable;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressWidget
extends JPanel {
    private static final ImageIcon IMG_CANCEL = new ImageIcon(ProgressWidget.class, "Cancel.png");
    private JProgressBar progress = new JProgressBar(0, 100);
    private Trackable track;
    private Timer timer;
    private Dimension minPreferredSize;

    public ProgressWidget(Trackable trackable) {
        super(new BorderLayout());
        JButton jButton = new JButton(new Cancel());
        jButton.setRequestFocusEnabled(false);
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.progress, "Center");
        this.add((Component)jButton, "East");
        this.progress.setStringPainted(true);
        this.track = trackable;
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressWidget.this.progress.setValue(ProgressWidget.this.track.getProgress());
                ProgressWidget.this.progress.setString(ProgressWidget.this.track.getState());
                ProgressWidget.this.revalidate();
                ProgressWidget.this.repaint();
            }
        });
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.minPreferredSize;
        this.minPreferredSize = super.getPreferredSize();
        if (dimension != null) {
            this.minPreferredSize.width = Math.max(this.minPreferredSize.width + 16, dimension.width);
            this.minPreferredSize.height = Math.max(this.minPreferredSize.height, dimension.height);
        }
        return this.minPreferredSize;
    }

    public void addNotify() {
        this.timer.start();
        super.addNotify();
    }

    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    private class Cancel
    extends Action2 {
        private Cancel() {
            this.setImage(IMG_CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProgressWidget.this.track.cancelTrackable();
        }
    }
}

