/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.renderer.DPI;
import genj.util.swing.UnitGraphics;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.JComponent;

public class ScreenResolutionScale
extends JComponent {
    private DPI dpi = new DPI(Toolkit.getDefaultToolkit().getScreenResolution(), Toolkit.getDefaultToolkit().getScreenResolution());
    private static final float DPI2CM = 0.39370078f;

    public ScreenResolutionScale(DPI dPI) {
        this.setDPI(dPI);
        this.addMouseMotionListener(new MouseGlue());
    }

    public DPI getDPI() {
        return this.dpi;
    }

    public void setDPI(DPI dPI) {
        this.dpi = dPI;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.paintLabel(graphics);
        this.paintScale(graphics);
    }

    private void paintScale(Graphics graphics) {
        UnitGraphics unitGraphics = new UnitGraphics(graphics, 0.39370078f * (float)this.dpi.horizontal(), 0.39370078f * (float)this.dpi.vertical());
        unitGraphics.setAntialiasing(true);
        unitGraphics.setFont(new Font("Arial", 0, 10));
        Rectangle2D rectangle2D = unitGraphics.getClip();
        int n = 1;
        do {
            unitGraphics.setColor(Color.gray);
            for (double d = 0.1; d < 0.9; d += 0.1) {
                unitGraphics.draw((double)n - d, 0.0, (double)n - d, 0.1);
            }
            unitGraphics.setColor(Color.black);
            unitGraphics.draw(n, 0.0, (double)n, 0.4);
            unitGraphics.draw("" + n, (double)n, 1.0, 0.0, 0.0);
        } while ((double)n++ < rectangle2D.getMaxX());
        int n2 = 1;
        do {
            unitGraphics.setColor(Color.gray);
            for (double d = 0.1; d < 0.9; d += 0.1) {
                unitGraphics.draw(0.0, (double)n2 - d, 0.1, (double)n2 - d);
            }
            unitGraphics.setColor(Color.black);
            unitGraphics.draw(0.0, (double)n2, 0.4, n2);
            unitGraphics.draw("" + n2, 1.0, (double)n2, 0.0, 0.0);
        } while ((double)n2++ < rectangle2D.getMaxY());
    }

    private void paintLabel(Graphics graphics) {
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String[] stringArray = new String[]{"" + numberFormat.format(this.dpi.horizontal()), "by", "" + numberFormat.format(this.dpi.vertical()), "DPI"};
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], this.getWidth() / 2 - fontMetrics.stringWidth(stringArray[i]) / 2, this.getHeight() / 2 - stringArray.length * n / 2 + i * n + n);
        }
        graphics.drawString("cm", 16, 16 + fontMetrics.getAscent());
    }

    public Dimension getPreferredSize() {
        return new Dimension(3 * this.dpi.horizontal(), 3 * this.dpi.vertical());
    }

    public Dimension getMinimumSize() {
        return new Dimension(64, 64);
    }

    private class MouseGlue
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean axis;
        private Point startPos = new Point();
        private Point startDPI = new Point();

        private MouseGlue() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.startPos.x = mouseEvent.getPoint().x;
            this.startPos.y = mouseEvent.getPoint().y;
            this.startDPI.x = ScreenResolutionScale.this.dpi.horizontal();
            this.startDPI.y = ScreenResolutionScale.this.dpi.vertical();
            this.axis = this.startPos.x > this.startPos.y;
            ScreenResolutionScale.this.setCursor(Cursor.getPredefinedCursor(this.axis ? 11 : 9));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            float f = mouseEvent.getPoint().x;
            float f2 = mouseEvent.getPoint().y;
            if (this.axis) {
                ScreenResolutionScale.this.dpi = new DPI((int)Math.max(10.0f, (float)this.startDPI.x * (f / (float)this.startPos.x)), ScreenResolutionScale.this.dpi.vertical());
            } else {
                ScreenResolutionScale.this.dpi = new DPI(ScreenResolutionScale.this.dpi.horizontal(), (int)Math.max(10.0f, (float)this.startDPI.y * (f2 / (float)this.startPos.y)));
            }
            ScreenResolutionScale.this.repaint();
        }
    }
}

