/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.Resources;
import genj.util.swing.Action2;
import java.util.ArrayList;
import java.util.List;

public interface ActionProvider {
    public void createActions(Context var1, Purpose var2, Action2.Group var3);

    public static class GedcomActionGroup
    extends Action2.Group {
        private Gedcom gedcom;

        public GedcomActionGroup(Gedcom gedcom) {
            super("Gedcom '" + gedcom.getName() + '\'', Gedcom.getImage());
            this.gedcom = gedcom;
        }

        public boolean equals(Object object) {
            return object instanceof GedcomActionGroup && ((GedcomActionGroup)object).gedcom.equals(this.gedcom);
        }

        public int hashCode() {
            return this.gedcom.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntitiesActionGroup
    extends Action2.Group {
        private List<Entity> es;

        public EntitiesActionGroup(List<? extends Entity> list) {
            super("'" + Property.getPropertyNames(list, 5) + "' (" + list.size() + ")");
            this.es = new ArrayList<Entity>(list);
        }

        public boolean equals(Object object) {
            return object instanceof EntitiesActionGroup && ((EntitiesActionGroup)object).es.equals(this.es);
        }

        public int hashCode() {
            return this.es.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesActionGroup
    extends Action2.Group {
        private List<Property> ps;

        public PropertiesActionGroup(List<? extends Property> list) {
            super("'" + Property.getPropertyNames(list, 5) + "' (" + list.size() + ")");
            this.ps = new ArrayList<Property>(list);
        }

        public boolean equals(Object object) {
            return object instanceof PropertiesActionGroup && ((PropertiesActionGroup)object).ps.equals(this.ps);
        }

        public int hashCode() {
            return this.ps.hashCode();
        }
    }

    public static class EntityActionGroup
    extends Action2.Group {
        private Entity e;

        public EntityActionGroup(Entity entity) {
            super(Gedcom.getName(entity.getTag(), false) + " '" + entity.getId() + '\'', entity.getImage(false));
            this.e = entity;
        }

        public boolean equals(Object object) {
            return object instanceof EntityActionGroup && ((EntityActionGroup)object).e.equals(this.e);
        }

        public int hashCode() {
            return this.e.hashCode();
        }
    }

    public static final class PropertyActionGroup
    extends Action2.Group {
        private Property p;

        public PropertyActionGroup(Property property) {
            super(Property.LABEL + " '" + TagPath.get(property).getName() + '\'', property.getImage(false));
            this.p = property;
        }

        public boolean equals(Object object) {
            return object instanceof PropertyActionGroup && ((PropertyActionGroup)object).p.equals(this.p);
        }

        public int hashCode() {
            return this.p.hashCode();
        }
    }

    public static final class EditActionGroup
    extends Action2.Group {
        public EditActionGroup() {
            super(Resources.get(EditActionGroup.class).getString("group.edit"));
        }

        public boolean equals(Object object) {
            return object instanceof EditActionGroup;
        }

        public int hashCode() {
            return EditActionGroup.class.hashCode();
        }
    }

    public static final class FileActionGroup
    extends Action2.Group {
        public FileActionGroup() {
            super(Resources.get(FileActionGroup.class).getString("group.file"));
        }

        public boolean equals(Object object) {
            return object instanceof FileActionGroup;
        }

        public int hashCode() {
            return FileActionGroup.class.hashCode();
        }
    }

    public static final class ViewActionGroup
    extends Action2.Group {
        public ViewActionGroup() {
            super(Resources.get(FileActionGroup.class).getString("group.view"), null, true);
        }

        public boolean equals(Object object) {
            return object instanceof ViewActionGroup;
        }

        public int hashCode() {
            return ViewActionGroup.class.hashCode();
        }
    }

    public static final class ToolsActionGroup
    extends Action2.Group {
        public ToolsActionGroup() {
            super(Resources.get(ToolsActionGroup.class).getString("group.tools"));
        }

        public boolean equals(Object object) {
            return object instanceof ToolsActionGroup;
        }

        public int hashCode() {
            return ToolsActionGroup.class.hashCode();
        }
    }

    public static final class HelpActionGroup
    extends Action2.Group {
        public HelpActionGroup() {
            super(Resources.get(HelpActionGroup.class).getString("group.help"));
        }

        public boolean equals(Object object) {
            return object instanceof HelpActionGroup;
        }

        public int hashCode() {
            return HelpActionGroup.class.hashCode();
        }
    }

    public static final class SeparatorAction
    extends Action2 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Purpose {
        TOOLBAR,
        CONTEXT,
        MENU;

    }
}

