/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd.tree;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import swingx.dnd.tree.DefaultDnDTreeModel;
import swingx.dnd.tree.DnDTreeModel;

public class DnDTree
extends JTree
implements Autoscroll {
    private static final int DEFAULT_AUTOSCROLL_MARGIN = 12;
    private int autoscrollMargin = 12;
    private DragGestureRecognizer dragGestureRecognizer;
    private DragHandler dragHandler;
    private DropHandler dropHandler;

    public DnDTree() {
        this(DnDTree.getDefaultTreeModel());
    }

    public DnDTree(TreeModel treeModel) {
        super(treeModel);
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler(){

            public int getSourceActions(JComponent jComponent) {
                return 1;
            }

            public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
                TreePath[] treePathArray;
                if (DnDTree.this.hasDnDModel() && (treePathArray = DnDTree.this.getSelectionPaths()) != null && treePathArray.length > 0) {
                    Arrays.sort(treePathArray, DnDTree.this.dragHandler);
                    Object[] objectArray = new Object[treePathArray.length];
                    for (int i = 0; i < treePathArray.length; ++i) {
                        if (treePathArray[i].getPathCount() <= 1) continue;
                        objectArray[i] = treePathArray[i].getLastPathComponent();
                    }
                    Transferable transferable = DnDTree.this.getDnDModel().createTransferable(objectArray);
                    try {
                        DnDTree.this.getDnDModel().drag(transferable, n);
                        clipboard.setContents(transferable, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                TreePath[] treePathArray = DnDTree.this.getSelectionPaths();
                if (treePathArray != null && treePathArray.length == 1 && treePathArray[0].getPathCount() > 0 && DnDTree.this.hasDnDModel()) {
                    try {
                        DnDTree.this.getDnDModel().drop(transferable, treePathArray[0].getLastPathComponent(), 0, 2);
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        });
        this.dragGestureRecognizer = new DragSource().createDefaultDragGestureRecognizer(this, 2, this.getDragSourceListener());
        new DropTarget(this, this.getDropTargetListener());
    }

    protected static TreeModel getDefaultTreeModel() {
        return new DefaultDnDTreeModel((MutableTreeNode)JTree.getDefaultTreeModel().getRoot());
    }

    public boolean hasDnDModel() {
        return this.getModel() instanceof DnDTreeModel;
    }

    public DnDTreeModel getDnDModel() {
        if (this.getModel() instanceof DnDTreeModel) {
            return (DnDTreeModel)this.getModel();
        }
        throw new IllegalStateException("no DnDTreeModel");
    }

    public int getAutoscrollMargin() {
        return this.autoscrollMargin;
    }

    public void setAutoscrollMargin(int n) {
        this.autoscrollMargin = n;
    }

    public void autoscroll(Point point) {
        Dimension dimension = this.getParent().getSize();
        int n = this.getClosestRowForLocation(point.x, point.y);
        if (n != -1) {
            n = this.getY() + point.y < dimension.height / 2 ? Math.max(0, n - 1) : Math.min(n + 1, this.getRowCount() - 1);
            this.scrollRowToVisible(n);
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getParent().getBounds();
        return new Insets(rectangle.y - this.getY() + this.autoscrollMargin, rectangle.x - this.getX() + this.autoscrollMargin, this.getHeight() - rectangle.height - rectangle.y + this.getY() + this.autoscrollMargin, this.getWidth() - rectangle.width - rectangle.x + this.getX() + this.autoscrollMargin);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.getDropTargetListener().paint(graphics);
    }

    protected DragHandler getDragSourceListener() {
        if (this.dragHandler == null) {
            this.dragHandler = new DragHandler();
        }
        return this.dragHandler;
    }

    protected DropHandler getDropTargetListener() {
        if (this.dropHandler == null) {
            this.dropHandler = new DropHandler();
        }
        return this.dropHandler;
    }

    protected Image createDragImage(TreePath[] treePathArray) {
        return this.createImage(1, 1);
    }

    private class DropHandler
    extends DropTargetAdapter
    implements ActionListener,
    TreeModelListener {
        private Timer timer;
        private TreePath parentPath;
        private int childIndex = 0;
        private Rectangle indicator;
        private List insertions = new ArrayList();

        public DropHandler() {
            this.timer = new Timer(1500, this);
            this.timer.setRepeats(false);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.dragOver(dropTargetDragEvent);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n = dropTargetDragEvent.getDropAction();
            boolean bl = false;
            if (DnDTree.this.hasDnDModel()) {
                this.update(dropTargetDragEvent.getLocation());
                if (this.parentPath != null) {
                    Transferable transferable = dropTargetDragEvent.getTransferable();
                    if (transferable == null) {
                        bl = true;
                    } else {
                        Object object = this.parentPath.getLastPathComponent();
                        boolean bl2 = bl = (DnDTree.this.getDnDModel().getDropActions(transferable, object, this.childIndex) & n) != 0;
                    }
                }
            }
            if (bl) {
                dropTargetDragEvent.acceptDrag(n);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.clear();
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n = dropTargetDropEvent.getDropAction();
            boolean bl = false;
            DnDTree.this.getModel().addTreeModelListener(this);
            try {
                Object object = null;
                if (DnDTree.this.hasDnDModel() && this.parentPath != null) {
                    dropTargetDropEvent.acceptDrop(n);
                    object = this.parentPath.getLastPathComponent();
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    if ((DnDTree.this.getDnDModel().getDropActions(transferable, object, this.childIndex) & n) != 0) {
                        DnDTree.this.getDnDModel().drop(transferable, object, this.childIndex, n);
                        bl = true;
                    }
                }
                dropTargetDropEvent.dropComplete(bl);
                if (!this.insertions.isEmpty() && object != null) {
                    DnDTree.this.getSelectionModel().clearSelection();
                    for (int i = 0; i < this.insertions.size(); ++i) {
                        TreePath treePath = (TreePath)this.insertions.get(i);
                        if (DnDTree.this.getModel().getIndexOfChild(object, treePath.getLastPathComponent()) < 0) continue;
                        DnDTree.this.getSelectionModel().addSelectionPath(treePath);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DnDTree.this.getModel().removeTreeModelListener(this);
            this.clear();
        }

        private void update(Point point) {
            TreePath treePath = this.parentPath;
            TreePath treePath2 = DnDTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath2 == null) {
                this.parentPath = null;
                this.childIndex = -1;
                this.indicator = null;
            } else if (treePath2.getPathCount() == 1) {
                this.parentPath = treePath2;
                this.childIndex = 0;
                this.indicator = null;
            } else {
                this.parentPath = treePath2.getParentPath();
                this.childIndex = DnDTree.this.getModel().getIndexOfChild(this.parentPath.getLastPathComponent(), treePath2.getLastPathComponent());
                this.indicator = DnDTree.this.getPathBounds(treePath2);
                if (DnDTree.this.getModel().isLeaf(treePath2.getLastPathComponent()) || point.y < this.indicator.y + this.indicator.height * 1 / 4 || point.y > this.indicator.y + this.indicator.height * 3 / 4 && !DnDTree.this.isExpanded(treePath2)) {
                    if (point.y > this.indicator.y + this.indicator.height / 2) {
                        this.indicator.y += this.indicator.height;
                        ++this.childIndex;
                    }
                    this.indicator.width = DnDTree.this.getWidth() - this.indicator.x - DnDTree.this.getInsets().right;
                    --this.indicator.y;
                    this.indicator.height = 2;
                } else {
                    this.parentPath = treePath2;
                    this.indicator = null;
                    this.childIndex = 0;
                }
            }
            DnDTree.this.repaint();
            if (this.parentPath == null) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.parentPath.equals(treePath)) {
                this.timer.start();
            }
        }

        private void clear() {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            this.parentPath = null;
            this.childIndex = -1;
            this.indicator = null;
            this.insertions.clear();
            DnDTree.this.repaint();
        }

        public TreePath getParentPath() {
            return this.parentPath;
        }

        public void paint(Graphics graphics) {
            if (this.indicator != null) {
                this.paintIndicator(graphics, this.indicator);
            }
        }

        private void paintIndicator(Graphics graphics, Rectangle rectangle) {
            graphics.setColor(DnDTree.this.getForeground());
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.x, rectangle.y - 2, rectangle.x + 1, rectangle.y - 2);
            graphics.drawLine(rectangle.x, rectangle.y - 1, rectangle.x + 2, rectangle.y - 1);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height + 0, rectangle.x + 2, rectangle.y + rectangle.height + 0);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height + 1, rectangle.x + 1, rectangle.y + rectangle.height + 1);
            graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y - 2, rectangle.x + rectangle.width - 1, rectangle.y - 2);
            graphics.drawLine(rectangle.x + rectangle.width - 3, rectangle.y - 1, rectangle.x + rectangle.width - 1, rectangle.y - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height + 0, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height + 0);
            graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height + 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height + 1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPath != null) {
                DnDTree.this.expandPath(this.parentPath);
            }
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            Object[] objectArray = treeModelEvent.getChildren();
            for (int i = 0; i < objectArray.length; ++i) {
                this.insertions.add(treeModelEvent.getTreePath().pathByAddingChild(objectArray[i]));
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.insertions.clear();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.insertions.clear();
            this.insertions.add(treeModelEvent.getTreePath());
        }
    }

    private class DragHandler
    extends DragSourceAdapter
    implements DragGestureListener,
    Comparator {
        private Transferable transferable;

        private DragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TreePath[] treePathArray;
            if (DnDTree.this.hasDnDModel() && (treePathArray = DnDTree.this.getSelectionPaths()) != null && treePathArray.length > 0) {
                Arrays.sort(treePathArray, this);
                boolean bl = false;
                Object[] objectArray = new Object[treePathArray.length];
                for (int i = 0; i < treePathArray.length; ++i) {
                    if (treePathArray[i].getPathCount() <= 0) continue;
                    objectArray[i] = treePathArray[i].getLastPathComponent();
                    Rectangle rectangle = DnDTree.this.getPathBounds(treePathArray[i]);
                    if (!rectangle.contains(dragGestureEvent.getDragOrigin())) continue;
                    bl = true;
                }
                if (bl) {
                    this.transferable = DnDTree.this.getDnDModel().createTransferable(objectArray);
                    DnDTree.this.dragGestureRecognizer.setSourceActions(DnDTree.this.getDnDModel().getDragActions(this.transferable));
                    dragGestureEvent.startDrag(null, DnDTree.this.createDragImage(treePathArray), new Point(), this.transferable, this);
                }
            }
        }

        public int compare(Object object, Object object2) {
            int n;
            TreePath treePath = (TreePath)object;
            TreePath treePath2 = (TreePath)object2;
            int n2 = DnDTree.this.getRowForPath(treePath);
            if (n2 < (n = DnDTree.this.getRowForPath(treePath2))) {
                return -1;
            }
            if (n < n2) {
                return 1;
            }
            return 0;
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess()) {
                try {
                    DnDTree.this.getDnDModel().drag(this.transferable, dragSourceDropEvent.getDropAction());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            DnDTree.this.getDnDModel().releaseTransferable(this.transferable);
            this.transferable = null;
            DnDTree.this.dragGestureRecognizer.setSourceActions(2);
        }
    }
}

