/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListMaker;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.util.ContentHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$fop$fo$FOTreeBuilder == null ? (class$org$apache$fop$fo$FOTreeBuilder = FOTreeBuilder.class$("org.apache.fop.fo.FOTreeBuilder")) : class$org$apache$fop$fo$FOTreeBuilder));
    protected ElementMappingRegistry elementMappingRegistry;
    protected Root rootFObj = null;
    protected MainFOHandler mainFOHandler;
    protected ContentHandler delegate;
    private FOEventHandler foEventHandler;
    private Locator locator;
    private FOUserAgent userAgent;
    private boolean used = false;
    private int depth;
    static /* synthetic */ Class class$org$apache$fop$fo$FOTreeBuilder;

    public FOTreeBuilder(String outputFormat, FOUserAgent foUserAgent, OutputStream stream) throws FOPException {
        this.userAgent = foUserAgent;
        this.foEventHandler = foUserAgent.getRendererFactory().createFOEventHandler(foUserAgent, outputFormat, stream);
        this.foEventHandler.setPropertyListMaker(new PropertyListMaker(){

            public PropertyList make(FObj fobj, PropertyList parentPropertyList) {
                return new StaticPropertyList(fobj, parentPropertyList);
            }
        });
        this.elementMappingRegistry = new ElementMappingRegistry(foUserAgent);
    }

    protected boolean isLocatorDisabled() {
        return false;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected Locator getEffectiveLocator() {
        return this.isLocatorDisabled() ? null : this.locator;
    }

    public void characters(char[] data, int start, int length) throws SAXException {
        this.delegate.characters(data, start, length);
    }

    public void startDocument() throws SAXException {
        if (this.used) {
            throw new IllegalStateException("FOTreeBuilder (and the Fop class) cannot be reused. Please instantiate a new instance.");
        }
        this.used = true;
        this.rootFObj = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building formatting object tree");
        }
        this.foEventHandler.startDocument();
        this.mainFOHandler = new MainFOHandler();
        this.mainFOHandler.startDocument();
        this.delegate = this.mainFOHandler;
    }

    public void endDocument() throws SAXException {
        this.delegate.endDocument();
        this.rootFObj = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Parsing of document complete");
        }
        this.foEventHandler.endDocument();
        ImageFactory.getInstance().removeContext(this.userAgent);
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attlist) throws SAXException {
        ++this.depth;
        this.delegate.startElement(namespaceURI, localName, rawName, attlist);
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        this.delegate.endElement(uri, localName, rawName);
        --this.depth;
        if (this.depth == 0 && this.delegate != this.mainFOHandler) {
            this.delegate.endDocument();
            this.delegate = this.mainFOHandler;
            this.delegate.endElement(uri, localName, rawName);
        }
    }

    private ElementMapping.Maker findFOMaker(String namespaceURI, String localName) throws FOPException {
        return this.elementMappingRegistry.findFOMaker(namespaceURI, localName, this.locator);
    }

    public void warning(SAXParseException e) {
        this.log.warn((Object)e.toString());
    }

    public void error(SAXParseException e) {
        this.log.error((Object)e.toString());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.log.error((Object)e.toString());
        throw e;
    }

    public FOEventHandler getEventHandler() {
        return this.foEventHandler;
    }

    public FormattingResults getResults() {
        if (this.getEventHandler() instanceof AreaTreeHandler) {
            return ((AreaTreeHandler)this.getEventHandler()).getResults();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MainFOHandler
    extends DefaultHandler {
        protected FONode currentFObj = null;
        protected PropertyList currentPropertyList;

        private MainFOHandler() {
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes attlist) throws SAXException {
            PropertyList propertyList;
            FONode foNode;
            if (FOTreeBuilder.this.rootFObj == null) {
                if (!namespaceURI.equals("http://www.w3.org/1999/XSL/Format") || !localName.equals("root")) {
                    throw new SAXException(new ValidationException("Error: First element must be the fo:root formatting object. Found " + FONode.getNodeString(namespaceURI, localName) + " instead." + " Please make sure you're producing a valid XSL-FO document."));
                }
            } else if (namespaceURI.equals("http://www.w3.org/1999/XSL/Format")) {
                this.currentFObj.validateChildNode(FOTreeBuilder.this.locator, namespaceURI, localName);
            }
            ElementMapping.Maker fobjMaker = FOTreeBuilder.this.findFOMaker(namespaceURI, localName);
            try {
                foNode = fobjMaker.make(this.currentFObj);
                propertyList = foNode.createPropertyList(this.currentPropertyList, FOTreeBuilder.this.foEventHandler);
                foNode.processNode(localName, FOTreeBuilder.this.getEffectiveLocator(), attlist, propertyList);
                foNode.startOfNode();
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
            ContentHandlerFactory chFactory = foNode.getContentHandlerFactory();
            if (chFactory != null) {
                ContentHandler subHandler = chFactory.createContentHandler();
                if (subHandler instanceof ContentHandlerFactory.ObjectSource && foNode instanceof ContentHandlerFactory.ObjectBuiltListener) {
                    ((ContentHandlerFactory.ObjectSource)((Object)subHandler)).setObjectBuiltListener((ContentHandlerFactory.ObjectBuiltListener)((Object)foNode));
                }
                subHandler.startDocument();
                subHandler.startElement(namespaceURI, localName, rawName, attlist);
                FOTreeBuilder.this.depth = 1;
                FOTreeBuilder.this.delegate = subHandler;
            }
            if (FOTreeBuilder.this.rootFObj == null) {
                FOTreeBuilder.this.rootFObj = (Root)foNode;
                FOTreeBuilder.this.rootFObj.setFOEventHandler(FOTreeBuilder.this.foEventHandler);
            } else {
                this.currentFObj.addChildNode(foNode);
            }
            this.currentFObj = foNode;
            if (propertyList != null) {
                this.currentPropertyList = propertyList;
            }
        }

        public void endElement(String uri, String localName, String rawName) throws SAXException {
            if (this.currentFObj == null) {
                throw new IllegalStateException("endElement() called for " + rawName + " where there is no current element.");
            }
            if (!this.currentFObj.getLocalName().equals(localName) || !this.currentFObj.getNamespaceURI().equals(uri)) {
                FOTreeBuilder.this.log.warn((Object)("Mismatch: " + this.currentFObj.getLocalName() + " (" + this.currentFObj.getNamespaceURI() + ") vs. " + localName + " (" + uri + ")"));
            }
            this.currentFObj.endOfNode();
            if (this.currentPropertyList.getFObj() == this.currentFObj) {
                this.currentPropertyList = this.currentPropertyList.getParentPropertyList();
            }
            if (this.currentFObj.getParent() == null) {
                FOTreeBuilder.this.log.debug((Object)("endElement for top-level " + this.currentFObj.getName()));
            }
            this.currentFObj = this.currentFObj.getParent();
        }

        public void characters(char[] data, int start, int length) throws FOPException {
            if (this.currentFObj != null) {
                this.currentFObj.addCharacters(data, start, start + length, this.currentPropertyList, FOTreeBuilder.this.getEffectiveLocator());
            }
        }

        public void endDocument() throws SAXException {
            this.currentFObj = null;
        }
    }
}

