/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.ValidationPercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;

public abstract class TableFObj
extends FObj {
    private Numeric borderAfterPrecedence;
    private Numeric borderBeforePrecedence;
    private Numeric borderEndPrecedence;
    private Numeric borderStartPrecedence;

    public TableFObj(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.borderAfterPrecedence = pList.get(20).getNumeric();
        this.borderBeforePrecedence = pList.get(24).getNumeric();
        this.borderEndPrecedence = pList.get(34).getNumeric();
        this.borderStartPrecedence = pList.get(48).getNumeric();
        if (this.getNameId() != 46 && this.getNameId() != 50 && this.getTable().isSeparateBorderModel() && this.getCommonBorderPaddingBackground().hasBorderInfo()) {
            this.attributeWarning("In the separate border model (border-collapse=\"separate\"), borders are not applicable to " + this.getName() + ", but a non-zero value for border was found.");
        }
        if (this.getNameId() != 46 && this.getNameId() != 50 && this.getCommonBorderPaddingBackground().hasPadding(ValidationPercentBaseContext.getPseudoContextForValidationPurposes())) {
            this.attributeWarning("padding-* properties are not applicable to " + this.getName() + ", but a non-zero value for padding was found.");
        }
    }

    public Numeric getBorderPrecedence(int side) {
        switch (side) {
            case 0: {
                return this.borderBeforePrecedence;
            }
            case 1: {
                return this.borderAfterPrecedence;
            }
            case 2: {
                return this.borderStartPrecedence;
            }
            case 3: {
                return this.borderEndPrecedence;
            }
        }
        return null;
    }

    public int getCurrentColumnIndex() {
        return 0;
    }

    public void setCurrentColumnIndex(int newIndex) {
    }

    public boolean isColumnNumberUsed(int colNr) {
        return false;
    }

    public Table getTable() {
        if (this.getNameId() == 46) {
            return (Table)this;
        }
        return ((TableFObj)this.parent).getTable();
    }

    public abstract CommonBorderPaddingBackground getCommonBorderPaddingBackground();

    protected static class PendingSpan {
        protected int rowsLeft;

        public PendingSpan(int rows) {
            this.rowsLeft = rows;
        }
    }
}

