/*
 * Decompiled with CFR 0.152.
 */
package com.coi.tools.os.win;

import com.coi.tools.os.win.MSWinConstants;
import com.coi.tools.os.win.NativeLibException;
import com.coi.tools.os.win.RegDataContainer;
import com.coi.tools.os.win.RegistryLogItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RegistryImpl
implements MSWinConstants {
    private static final String DEFAULT_PLACEHOLDER = "__#$&DEFAULT_PLACEHODER_VALUE#$?";
    private int currentRoot = -2147483647;
    private List logging = new ArrayList();
    private boolean doLogging = false;

    public int getRoot() {
        return this.currentRoot;
    }

    public void setRoot(int i) {
        this.currentRoot = i;
    }

    public RegDataContainer getValue(String key, String value) throws NativeLibException {
        if (key == null) {
            key = "";
        }
        return this.getValue(this.currentRoot, key, value);
    }

    public Object getValueAsObject(String key, String value) throws NativeLibException {
        if (key == null) {
            key = "";
        }
        return this.getValue(this.currentRoot, key, value).getDataAsObject();
    }

    public String[] getSubkeys(String key) throws NativeLibException {
        if (key == null) {
            key = "";
        }
        return this.getSubkeyNames(this.currentRoot, key);
    }

    public String[] getValueNames(String key) throws NativeLibException {
        if (key == null) {
            key = "";
        }
        return this.getValueNames(this.currentRoot, key);
    }

    public void createKey(String key) throws NativeLibException {
        this.createKey(this.currentRoot, key);
    }

    public void createKey(int root, String key) throws NativeLibException {
        String subkey;
        int pathEnd = key.lastIndexOf(92);
        if (pathEnd > 0 && !this.exist(root, subkey = key.substring(0, pathEnd))) {
            this.createKey(root, subkey);
        }
        this.createKeyN(root, key);
        RegistryLogItem rli = new RegistryLogItem(2, root, key, null, null, null);
        this.log(rli);
    }

    public boolean keyExist(String key) throws NativeLibException {
        return this.keyExist(this.currentRoot, key);
    }

    public boolean keyExist(int root, String key) throws NativeLibException {
        try {
            return this.exist(root, key);
        }
        catch (NativeLibException ne) {
            String em = ne.getLibMessage();
            if ("functionFailed.RegOpenKeyEx".equals(em)) {
                return false;
            }
            throw ne;
        }
    }

    public boolean valueExist(String key, String value) throws NativeLibException {
        if (key == null) {
            key = "";
        }
        try {
            this.getValue(this.currentRoot, key, value);
        }
        catch (NativeLibException ne) {
            String em = ne.getLibMessage();
            if ("functionFailed.RegOpenKeyEx".equals(em) || "functionFailed.RegQueryValueEx".equals(em)) {
                return false;
            }
            throw ne;
        }
        return true;
    }

    public void setValue(String key, String value, String contents) throws NativeLibException {
        this.setValue(this.currentRoot, key, value, new RegDataContainer(contents));
    }

    public void setValue(String key, String value, String[] contents) throws NativeLibException {
        this.setValue(this.currentRoot, key, value, new RegDataContainer(contents));
    }

    public void setValue(String key, String value, byte[] contents) throws NativeLibException {
        this.setValue(this.currentRoot, key, value, new RegDataContainer(contents));
    }

    public void setValue(String key, String value, long contents) throws NativeLibException {
        this.setValue(this.currentRoot, key, value, new RegDataContainer(contents));
    }

    public void setValue(String key, String value, RegDataContainer contents) throws NativeLibException {
        this.setValue(this.currentRoot, key, value, contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int root, String key, String value, RegDataContainer contents) throws NativeLibException {
        RegDataContainer oldContents = null;
        String localValue = value;
        if (key == null) {
            key = "";
        }
        if (value == null) {
            value = "";
        }
        key = key.replace('/', '\\');
        List list = this.logging;
        synchronized (list) {
            try {
                oldContents = this.getValue(this.currentRoot, key, value);
            }
            catch (NativeLibException ne) {
                String em = ne.getLibMessage();
                if ("functionFailed.RegOpenKeyEx".equals(em) || "functionFailed.RegQueryValueEx".equals(em)) {
                    this.setValueR(root, key, value, contents);
                    return;
                }
                throw ne;
            }
            this.setValueN(root, key, value, contents);
            if (value.length() == 0) {
                localValue = DEFAULT_PLACEHOLDER;
            }
            RegistryLogItem rli = new RegistryLogItem(5, root, key, localValue, contents, oldContents);
            this.log(rli);
        }
    }

    public void deleteKey(String key) throws NativeLibException {
        this.deleteKeyL(this.currentRoot, key);
    }

    public void deleteKeyIfEmpty(String key) throws NativeLibException {
        this.deleteKeyIfEmpty(this.currentRoot, key);
    }

    public void deleteKeyIfEmpty(int root, String key) throws NativeLibException {
        if (this.keyExist(root, key) && this.isKeyEmpty(root, key)) {
            this.deleteKeyL(root, key);
        }
    }

    public void deleteValue(String key, String value) throws NativeLibException {
        this.deleteValueL(this.currentRoot, key, value);
    }

    private void deleteKeyL(int root, String key) throws NativeLibException {
        RegistryLogItem rli = new RegistryLogItem(1, root, key, null, null, null);
        this.log(rli);
        this.deleteKeyN(root, key);
    }

    private void deleteValueL(int root, String key, String value) throws NativeLibException {
        if (key == null) {
            key = "";
        }
        RegDataContainer oldContents = this.getValue(this.currentRoot, key, value);
        RegistryLogItem rli = new RegistryLogItem(3, root, key, value, null, oldContents);
        this.log(rli);
        this.deleteValueN(this.currentRoot, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() throws IllegalArgumentException, NativeLibException {
        List list = this.logging;
        synchronized (list) {
            Iterator iter = this.logging.iterator();
            this.suspendLogging();
            while (iter.hasNext()) {
                RegistryLogItem rli = (RegistryLogItem)iter.next();
                String rliValueName = DEFAULT_PLACEHOLDER.equals(rli.getValueName()) ? "" : rli.getValueName();
                switch (rli.getType()) {
                    case 2: {
                        this.deleteKeyIfEmpty(rli.getRoot(), rli.getKey());
                        break;
                    }
                    case 1: {
                        this.createKeyN(rli.getRoot(), rli.getKey());
                        break;
                    }
                    case 4: {
                        RegDataContainer currentContents = null;
                        try {
                            currentContents = this.getValue(rli.getRoot(), rli.getKey(), rliValueName);
                        }
                        catch (NativeLibException nle) {
                            break;
                        }
                        if (!currentContents.equals(rli.getNewValue())) break;
                        this.deleteValueN(rli.getRoot(), rli.getKey(), rliValueName);
                        break;
                    }
                    case 3: {
                        try {
                            this.getValue(rli.getRoot(), rli.getKey(), rliValueName);
                        }
                        catch (NativeLibException nle) {
                            this.setValueN(rli.getRoot(), rli.getKey(), rliValueName, rli.getOldValue());
                        }
                        break;
                    }
                    case 5: {
                        RegDataContainer currentContents;
                        try {
                            currentContents = this.getValue(rli.getRoot(), rli.getKey(), rliValueName);
                        }
                        catch (NativeLibException nle) {
                            break;
                        }
                        if (!currentContents.equals(rli.getNewValue())) break;
                        this.setValueN(rli.getRoot(), rli.getKey(), rliValueName, rli.getOldValue());
                    }
                }
            }
        }
    }

    private void setValueR(int root, String key, String value, RegDataContainer contents) throws NativeLibException {
        String localValue = value;
        if (!this.exist(root, key)) {
            this.createKey(root, key);
        }
        this.setValueN(root, key, value, contents);
        if (value.length() == 0) {
            localValue = DEFAULT_PLACEHOLDER;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SetValue;").append(Integer.toString(root)).append(";").append(key).append(";").append(localValue);
        RegistryLogItem rli = new RegistryLogItem(4, root, key, localValue, contents, null);
        this.log(rli);
    }

    private native boolean exist(int var1, String var2) throws NativeLibException;

    private native void createKeyN(int var1, String var2) throws NativeLibException;

    private native void setValueN(int var1, String var2, String var3, RegDataContainer var4) throws NativeLibException;

    private native RegDataContainer getValue(int var1, String var2, String var3) throws NativeLibException;

    private native void deleteValueN(int var1, String var2, String var3) throws NativeLibException;

    private native void deleteKeyN(int var1, String var2) throws NativeLibException;

    private native boolean isKeyEmpty(int var1, String var2) throws NativeLibException;

    private native String[] getSubkeyNames(int var1, String var2) throws NativeLibException;

    private native String[] getValueNames(int var1, String var2) throws NativeLibException;

    public void resetLogging() {
        this.logging = new ArrayList();
        this.activateLogging();
    }

    public void suspendLogging() {
        this.doLogging = false;
    }

    public void activateLogging() {
        this.doLogging = true;
    }

    public List getLoggingInfo() {
        ArrayList<Object> retval = new ArrayList<Object>(this.logging.size());
        Iterator iter = this.logging.iterator();
        while (iter.hasNext()) {
            try {
                retval.add(((RegistryLogItem)iter.next()).clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    public void setLoggingInfo(List info) {
        this.resetLogging();
        this.addLoggingInfo(info);
    }

    public void addLoggingInfo(List info) {
        Iterator iter = info.iterator();
        while (iter.hasNext()) {
            try {
                this.logging.add(((RegistryLogItem)iter.next()).clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    private void log(RegistryLogItem item) {
        if (this.doLogging && this.logging != null) {
            this.logging.add(0, item);
        }
    }
}

