/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.GUIListener;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class InstallerFrame
extends JFrame {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String ICON_RESOURCE = "Installer.image";
    private static final String HEADING_ICON_RESOURCE = "Heading.image";
    public LocaleDatabase langpack;
    protected InstallData installdata;
    public IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton quitButton;
    protected ArrayList visiblePanelMapping;
    protected ArrayList guiListener = new ArrayList();
    protected JLabel[] headingLabels;
    protected JPanel headingPanel;
    protected JComponent headingCounterComponent;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    protected RulesEngine rules;
    private static final String CONDITIONS_SPECRESOURCENAME = "conditions.xml";
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";
    private boolean isBack = false;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(String title, InstallData installdata) throws Exception {
        super(title);
        this.visiblePanelMapping = new ArrayList();
        this.installdata = installdata;
        this.langpack = installdata.langpack;
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.loadConditions();
        this.loadIcons();
        this.loadCustomIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    protected void loadConditions() {
        try {
            InputStream input = null;
            input = this.getResource(CONDITIONS_SPECRESOURCENAME);
            if (input == null) {
                this.rules = new RulesEngine(null, this.installdata);
                return;
            }
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(new StdXMLBuilder());
            parser.setValidator(new NonValidator());
            parser.setReader(new StdXMLReader(input));
            XMLElement conditionsxml = (XMLElement)parser.parse();
            this.rules = new RulesEngine(conditionsxml, this.installdata);
        }
        catch (Exception e) {
            Debug.trace("Can not find optional resource conditions.xml");
            this.rules = new RulesEngine(null, this.installdata);
        }
    }

    private void loadPanels() throws Exception {
        List panelsOrder = this.installdata.panelsOrder;
        int size = panelsOrder.size();
        Class[] paramsClasses = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] params = new Object[]{this, this.installdata};
        int curVisPanelNumber = 0;
        int lastVis = 0;
        int count = 0;
        for (int i = 0; i < size; ++i) {
            Panel p = (Panel)panelsOrder.get(i);
            if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
            String className = p.className;
            String praefix = "com.izforge.izpack.panels.";
            if (className.indexOf(46) > -1) {
                praefix = "";
            }
            Class<?> objectClass = Class.forName(praefix + className);
            Constructor<?> constructor = objectClass.getDeclaredConstructor(paramsClasses);
            this.installdata.currentPanel = p;
            Object object = constructor.newInstance(params);
            IzPanel panel = (IzPanel)object;
            this.installdata.panels.add(panel);
            if (panel.isHidden()) {
                this.visiblePanelMapping.add(count, new Integer(-1));
            } else {
                this.visiblePanelMapping.add(count, new Integer(curVisPanelNumber));
                ++curVisPanelNumber;
                lastVis = count;
            }
            ++count;
            XMLElement panelRoot = new XMLElement(className);
            this.installdata.xmlData.addChild(panelRoot);
        }
        this.visiblePanelMapping.add(count, new Integer(lastVis));
    }

    private void loadIcons() throws Exception {
        ImageIcon img;
        URL url;
        XMLElement icon;
        int i;
        this.icons = new IconsDatabase();
        InputStream inXML = InstallerFrame.class.getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setReader(new StdXMLReader(inXML));
        parser.setValidator(new NonValidator());
        XMLElement data = (XMLElement)parser.parse();
        Vector children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = (class$com$izforge$izpack$installer$InstallerFrame == null ? InstallerFrame.class$("com.izforge.izpack.installer.InstallerFrame") : class$com$izforge$izpack$installer$InstallerFrame).getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = (class$com$izforge$izpack$installer$InstallerFrame == null ? InstallerFrame.class$("com.izforge.izpack.installer.InstallerFrame") : class$com$izforge$izpack$installer$InstallerFrame).getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    protected void loadCustomIcons() throws Exception {
        ImageIcon img;
        URL url;
        XMLElement icon;
        int i;
        InputStream inXML = null;
        try {
            inXML = ResourceManager.getInstance().getInputStream(CUSTOM_ICONS_RESOURCEFILE);
        }
        catch (Throwable exception) {
            Debug.trace("Resource customicons.xml not defined. No custom icons available.");
            return;
        }
        Debug.trace("Custom icons available.");
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setReader(new StdXMLReader(inXML));
        parser.setValidator(new NonValidator());
        XMLElement data = (XMLElement)parser.parse();
        Vector children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = (class$com$izforge$izpack$installer$InstallerFrame == null ? InstallerFrame.class$("com.izforge.izpack.installer.InstallerFrame") : class$com$izforge$izpack$installer$InstallerFrame).getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            Debug.trace("Icon with id found: " + icon.getAttribute("id"));
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = (class$com$izforge$izpack$installer$InstallerFrame == null ? InstallerFrame.class$("com.izforge.izpack.installer.InstallerFrame") : class$com$izforge$izpack$installer$InstallerFrame).getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    private void buildGUI() {
        this.setDefaultCloseOperation(0);
        this.setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        glassPane.addFocusListener(new FocusAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel panel_0 = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(panel_0);
        NavigationHandler navHandler = new NavigationHandler();
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 0));
        navPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(new EtchedLineBorder(), this.langpack.getString("installer.madewith") + " ", 0, 0, new Font("Dialog", 0, 10))));
        navPanel.add(Box.createHorizontalGlue());
        this.prevButton = ButtonFactory.createButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        navPanel.add(this.prevButton);
        this.prevButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        navPanel.add(this.nextButton);
        this.nextButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        navPanel.add(this.quitButton);
        this.quitButton.addActionListener(navHandler);
        this.contentPane.add((Component)navPanel, "South");
        try {
            ImageIcon icon = this.loadIcon(ICON_RESOURCE, 0, true);
            if (icon != null) {
                JPanel imgPanel = new JPanel();
                imgPanel.setLayout(new BorderLayout());
                imgPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
                this.iconLabel = new JLabel(icon);
                this.iconLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                imgPanel.add((Component)this.iconLabel, "North");
                this.contentPane.add((Component)imgPanel, "West");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.loadAndShowImage(0);
        this.getRootPane().setDefaultButton(this.nextButton);
        this.callGUIListener(0, navPanel);
        this.createHeading(navPanel);
    }

    private void callGUIListener(int what) {
        this.callGUIListener(what, null);
    }

    private void callGUIListener(int what, Object param) {
        Iterator iter = this.guiListener.iterator();
        while (iter.hasNext()) {
            ((GUIListener)iter.next()).guiActionPerformed(what, param);
        }
    }

    private ImageIcon loadIcon(String resPrefix, int PanelNo, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e) {
                icon = rm.getImageIconResource(resPrefix + "." + PanelNo);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + PanelNo);
        }
        return icon;
    }

    private ImageIcon loadIcon(String resPrefix, String panelid, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e) {
                icon = rm.getImageIconResource(resPrefix + "." + panelid);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + panelid);
        }
        return icon;
    }

    private void loadAndShowImage(int panelNo) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo);
    }

    private void loadAndShowImage(int panelNo, String panelid) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo, panelid);
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelno, String panelid) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelid, false);
        }
        catch (Exception e) {
            try {
                icon = this.loadIcon(resPrefix, panelno, false);
            }
            catch (Exception ex) {
                try {
                    icon = this.loadIcon(resPrefix, panelid, true);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelNo) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelNo, false);
        }
        catch (Exception e) {
            try {
                icon = this.loadIcon(resPrefix, panelNo, true);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
    }

    protected void switchPanel(int last) {
        try {
            if (this.installdata.curPanelNumber < last) {
                this.isBack = true;
            }
            this.panelsContainer.setVisible(false);
            IzPanel panel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
            IzPanel l_panel = (IzPanel)this.installdata.panels.get(last);
            if ((Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber) == 0) {
                this.prevButton.setVisible(false);
                this.lockPrevButton();
                this.unlockNextButton();
            } else if ((Integer)this.visiblePanelMapping.get(this.installdata.panels.size()) == this.installdata.curPanelNumber) {
                this.prevButton.setVisible(false);
                this.nextButton.setVisible(false);
                this.lockNextButton();
            } else {
                this.prevButton.setVisible(true);
                this.nextButton.setVisible(true);
                this.unlockPrevButton();
                this.unlockNextButton();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JButton cdb = null;
                    if (InstallerFrame.this.nextButton.isEnabled()) {
                        cdb = InstallerFrame.this.nextButton;
                        InstallerFrame.this.quitButton.setDefaultCapable(false);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(true);
                    } else if (InstallerFrame.this.quitButton.isEnabled()) {
                        cdb = InstallerFrame.this.quitButton;
                        InstallerFrame.this.quitButton.setDefaultCapable(true);
                        InstallerFrame.this.prevButton.setDefaultCapable(false);
                        InstallerFrame.this.nextButton.setDefaultCapable(false);
                    }
                    InstallerFrame.this.getRootPane().setDefaultButton(cdb);
                }
            });
            this.panelsContainer.remove(l_panel);
            l_panel.panelDeactivate();
            this.panelsContainer.add(panel);
            if (panel.getInitialFocus() != null) {
                JTextComponent inText;
                final Component inFoc = panel.getInitialFocus();
                if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
                    inFoc.requestFocus();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            inFoc.requestFocusInWindow();
                        }
                    });
                }
                if (inFoc instanceof JTextComponent && (inText = (JTextComponent)inFoc).isEditable() && inText.getDocument() != null) {
                    inText.setCaretPosition(inText.getDocument().getLength());
                }
            }
            this.performHeading(panel);
            this.performHeadingCounter(panel);
            panel.panelActivate();
            this.panelsContainer.setVisible(true);
            Panel metadata = panel.getMetadata();
            if (metadata != null && !"UNKNOWN".equals(metadata.getPanelid())) {
                this.loadAndShowImage((Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber), metadata.getPanelid());
            } else {
                this.loadAndShowImage((Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber));
            }
            this.isBack = false;
            this.callGUIListener(3);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void writeUninstallData() {
        String logfile = this.installdata.getVariable("InstallerFrame.logfilePath");
        BufferedWriter extLogWriter = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = "$INSTALL_PATH/Uninstaller/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, new VariableSubstitutor(this.installdata.getVariables())))).getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                Debug.trace("Cannot create logfile!");
                Debug.error(e);
            }
            if (out != null) {
                extLogWriter = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        try {
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getFilesList();
            ZipOutputStream outJar = this.installdata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(this.installdata.getInstallPath());
            logWriter.newLine();
            Iterator iter = files.iterator();
            if (extLogWriter != null) {
                while (iter.hasNext()) {
                    String txt = (String)iter.next();
                    logWriter.write(txt);
                    extLogWriter.write(txt);
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                    extLogWriter.newLine();
                }
                logWriter.flush();
                extLogWriter.flush();
                extLogWriter.close();
            } else {
                while (iter.hasNext()) {
                    logWriter.write((String)iter.next());
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                }
                logWriter.flush();
            }
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            Map additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = (String)keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            Iterator liClaIter = customData.contents.iterator();
                            while (liClaIter.hasNext()) {
                                String contentPath = (String)liClaIter.next();
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            outJar.putNextEntry(new ZipEntry("rootscript"));
            ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
            String rootScript = udata.getRootScript();
            rootStream.writeUTF(rootScript);
            rootStream.flush();
            outJar.closeEntry();
            outJar.flush();
            outJar.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public InputStream getResource(String res) throws Exception {
        String basePath = "";
        ResourceManager rm = null;
        try {
            rm = ResourceManager.getInstance();
            rm.getClass();
            basePath = "/res/";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream result = this.getClass().getResourceAsStream(basePath + res);
        if (result == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + res);
        }
        return result;
    }

    public void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public void exit() {
        if (this.installdata.canClose) {
            this.writeUninstallData();
            Housekeeper.getInstance().shutDown(0);
        } else {
            VariableSubstitutor vs;
            int res;
            if (Unpacker.isDiscardInterrupt() && this.interruptCount < 3) {
                ++this.interruptCount;
                return;
            }
            String mkey = "installer.quit.reversemessage";
            String tkey = "installer.quit.reversetitle";
            String message = this.langpack.getString("installer.quit.reversemessage");
            String title = this.langpack.getString("installer.quit.reversetitle");
            if (message.indexOf("installer.quit.reversemessage") > -1) {
                message = this.langpack.getString("installer.quit.message");
            }
            if (title.indexOf("installer.quit.reversetitle") > -1) {
                title = this.langpack.getString("installer.quit.title");
            }
            if ((res = JOptionPane.showConfirmDialog(this, message = (vs = new VariableSubstitutor(this.installdata.getVariables())).substitute(message, null), title = vs.substitute(title, null), 0)) == 0) {
                this.wipeAborted();
                Housekeeper.getInstance().shutDown(0);
            }
        }
    }

    protected void wipeAborted() {
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
        UninstallData u = UninstallData.getInstance();
        Iterator it = u.getFilesList().iterator();
        if (!it.hasNext()) {
            return;
        }
        while (it.hasNext()) {
            String p = (String)it.next();
            File f = new File(p);
            f.delete();
        }
        String fullCleanup = this.installdata.getVariable("InstallerFrame.cleanAllAtInterrupt");
        if (fullCleanup == null || !"no".equalsIgnoreCase(fullCleanup)) {
            this.cleanWipe(new File(this.installdata.getInstallPath()));
        }
    }

    private void cleanWipe(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                this.cleanWipe(files[i]);
            }
        }
        file.delete();
    }

    public void install(AbstractUIProgressHandler listener) {
        Unpacker unpacker = new Unpacker(this.installdata, listener);
        unpacker.start();
    }

    public void writeXMLTree(XMLElement root, OutputStream out) throws Exception {
        XMLWriter writer = new XMLWriter(out);
        for (int i = 0; i < this.installdata.panels.size(); ++i) {
            IzPanel panel = (IzPanel)this.installdata.panels.get(i);
            panel.makeXMLData(this.installdata.xmlData.getChildAtIndex(i));
        }
        writer.write(this.installdata.xmlData);
    }

    public void setQuitButtonText(String text) {
        String text1 = text;
        if (text1 == null) {
            text1 = this.langpack.getString("installer.quit");
        }
        this.quitButton.setText(text1);
    }

    public void setQuitButtonIcon(String iconName) {
        String useButtonIcons = (String)this.installdata.guiPrefs.modifier.get("useButtonIcons");
        if (useButtonIcons == null || "yes".equalsIgnoreCase(useButtonIcons)) {
            this.quitButton.setIcon(this.icons.getImageIcon(iconName));
        }
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
        this.callGUIListener(1);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
        this.callGUIListener(2);
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.nextButton.setEnabled(true);
        this.nextButton.requestFocus();
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            if (this.isBack) {
                --this.installdata.curPanelNumber;
                this.switchPanel(this.installdata.curPanelNumber + 1);
            } else {
                ++this.installdata.curPanelNumber;
                this.switchPanel(this.installdata.curPanelNumber - 1);
            }
        }
    }

    public boolean canShow(int panelnumber) {
        IzPanel panel = (IzPanel)this.installdata.panels.get(panelnumber);
        String panelid = panel.getMetadata().getPanelid();
        Debug.trace("Current Panel: " + panelid);
        if (!this.getRules().canShowPanel(panelid, this.installdata.variables)) {
            Debug.log("Skip panel with panelid=" + panelid);
            return false;
        }
        return true;
    }

    public void navigateNext() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        this.navigateNext(this.installdata.curPanelNumber);
    }

    public void navigateNext(int last) {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            ++this.installdata.curPanelNumber;
            if (!this.canShow(this.installdata.curPanelNumber)) {
                this.navigateNext(last);
                return;
            }
            if (((IzPanel)this.installdata.panels.get(last)).isValidated()) {
                this.switchPanel(last);
            } else {
                --this.installdata.curPanelNumber;
            }
        }
    }

    public void navigatePrevious() {
        if (!this.prevButton.isEnabled()) {
            return;
        }
        this.navigatePrevious(this.installdata.curPanelNumber);
    }

    public void navigatePrevious(int last) {
        if (this.installdata.curPanelNumber > 0) {
            --this.installdata.curPanelNumber;
            if (!this.canShow(this.installdata.curPanelNumber)) {
                this.navigatePrevious(last);
                return;
            }
            this.switchPanel(last);
        }
    }

    public List getGuiListener() {
        return this.guiListener;
    }

    public void addGuiListener(GUIListener listener) {
        this.guiListener.add(listener);
    }

    private void createHeadingLabels(int headingLines, Color back) {
        float fontSize;
        this.headingLabels = new JLabel[headingLines + 1];
        this.headingLabels[0] = new JLabel("");
        this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(1));
        if (this.installdata.guiPrefs.modifier.containsKey("headingFontSize") && (double)(fontSize = Float.parseFloat((String)this.installdata.guiPrefs.modifier.get("headingFontSize"))) > 0.0 && (double)fontSize <= 5.0) {
            float currentSize = this.headingLabels[0].getFont().getSize2D();
            this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(currentSize * fontSize));
        }
        for (int i = 1; i < headingLines; ++i) {
            this.headingLabels[i] = new JLabel();
            this.headingLabels[i].setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        }
    }

    private void createHeadingCounter(Color back, JPanel navPanel, JPanel leftHeadingPanel) {
        String counterPos = "inHeading";
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounterPos")) {
            counterPos = (String)this.installdata.guiPrefs.modifier.get("headingPanelCounterPos");
        }
        if (leftHeadingPanel == null && "inHeading".equalsIgnoreCase(counterPos)) {
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounter")) {
            this.headingCounterComponent = null;
            if ("progressbar".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JProgressBar headingProgressBar = new JProgressBar();
                headingProgressBar.setStringPainted(true);
                headingProgressBar.setString("");
                headingProgressBar.setValue(0);
                this.headingCounterComponent = headingProgressBar;
            } else if ("text".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JLabel headingCountPanels = new JLabel(" ");
                this.headingCounterComponent = headingCountPanels;
                this.headingCounterComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
            }
            if ("inHeading".equals(counterPos)) {
                leftHeadingPanel.add(this.headingCounterComponent);
            } else if ("inNavigationPanel".equals(counterPos)) {
                int i;
                Component[] comps = navPanel.getComponents();
                for (i = 0; i < comps.length && !comps[i].equals(this.prevButton); ++i) {
                }
                if (i <= comps.length) {
                    navPanel.add(Box.createHorizontalGlue(), i);
                    navPanel.add((Component)this.headingCounterComponent, i);
                }
            }
        }
    }

    private JPanel createHeadingIcon(Color back) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(HEADING_ICON_RESOURCE, 0, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        JPanel imgPanel = new JPanel();
        imgPanel.setLayout(new BoxLayout(imgPanel, 1));
        imgPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        if (back != null) {
            imgPanel.setBackground(back);
        }
        JLabel iconLab = new JLabel(icon);
        imgPanel.add((Component)iconLab, "East");
        this.headingLabels[this.headingLabels.length - 1] = iconLab;
        return imgPanel;
    }

    private void createHeading(JPanel navPanel) {
        this.headingPanel = null;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        Color back = null;
        int i = 0;
        if (this.installdata.guiPrefs.modifier.containsKey("headingBackgroundColor")) {
            back = Color.decode((String)this.installdata.guiPrefs.modifier.get("headingBackgroundColor"));
        }
        if (!this.isHeading(null)) {
            this.createHeadingCounter(back, navPanel, null);
            return;
        }
        this.createHeadingLabels(headingLines, back);
        JPanel leftHeadingPanel = new JPanel();
        if (back != null) {
            leftHeadingPanel.setBackground(back);
        }
        leftHeadingPanel.setLayout(new BoxLayout(leftHeadingPanel, 1));
        for (i = 0; i < headingLines; ++i) {
            leftHeadingPanel.add(this.headingLabels[i]);
        }
        this.createHeadingCounter(back, navPanel, leftHeadingPanel);
        JPanel imgPanel = this.createHeadingIcon(back);
        JPanel northPanel = new JPanel();
        if (back != null) {
            northPanel.setBackground(back);
        }
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        northPanel.add(leftHeadingPanel);
        northPanel.add(Box.createHorizontalGlue());
        northPanel.add(imgPanel);
        this.headingPanel = new JPanel(new BorderLayout());
        this.headingPanel.add(northPanel);
        this.headingPanel.add((Component)new JSeparator(), "South");
        this.contentPane.add((Component)this.headingPanel, "North");
    }

    public boolean isHeading(IzPanel caller) {
        if (!this.installdata.guiPrefs.modifier.containsKey("useHeadingPanel") || !((String)this.installdata.guiPrefs.modifier.get("useHeadingPanel")).equalsIgnoreCase("yes")) {
            return false;
        }
        if (caller == null) {
            return true;
        }
        return caller.getI18nStringForClass("headline", null) != null;
    }

    private void performHeading(IzPanel panel) {
        int i;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt((String)this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        if (this.headingLabels == null) {
            return;
        }
        String headline = panel.getI18nStringForClass("headline");
        if (headline == null) {
            this.headingPanel.setVisible(false);
            return;
        }
        for (i = 0; i <= headingLines; ++i) {
            if (this.headingLabels[i] == null) continue;
            this.headingLabels[i].setVisible(false);
        }
        for (i = 0; i < headingLines - 1; ++i) {
            String info = panel.getI18nStringForClass("headinfo" + Integer.toString(i));
            if (info == null) {
                info = " ";
            }
            if (info.endsWith(":")) {
                info = info.substring(0, info.length() - 1) + ".";
            }
            this.headingLabels[i + 1].setText(info);
            this.headingLabels[i + 1].setVisible(true);
        }
        this.headingLabels[0].setText(headline);
        this.headingLabels[0].setVisible(true);
        int curPanelNo = (Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber);
        if (this.headingLabels[headingLines] != null) {
            this.loadAndShowImage(this.headingLabels[headingLines], HEADING_ICON_RESOURCE, curPanelNo);
            this.headingLabels[headingLines].setVisible(true);
        }
        this.headingPanel.setVisible(true);
    }

    private void performHeadingCounter(IzPanel panel) {
        if (this.headingCounterComponent != null) {
            int curPanelNo = (Integer)this.visiblePanelMapping.get(this.installdata.curPanelNumber);
            int visPanelsCount = (Integer)this.visiblePanelMapping.get((Integer)this.visiblePanelMapping.get(this.installdata.panels.size()));
            StringBuffer buf = new StringBuffer();
            buf.append(this.langpack.getString("installer.step")).append(" ").append(curPanelNo + 1).append(" ").append(this.langpack.getString("installer.of")).append(" ").append(visPanelsCount + 1);
            if (this.headingCounterComponent instanceof JProgressBar) {
                JProgressBar headingProgressBar = (JProgressBar)this.headingCounterComponent;
                headingProgressBar.setMaximum(visPanelsCount + 1);
                headingProgressBar.setValue(curPanelNo + 1);
                headingProgressBar.setString(buf.toString());
            } else {
                ((JLabel)this.headingCounterComponent).setText(buf.toString());
            }
        }
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        protected boolean accept(Component aComp) {
            return aComp == InstallerFrame.this.getGlassPane();
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            InstallerFrame.this.exit();
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == InstallerFrame.this.prevButton) {
                InstallerFrame.this.navigatePrevious();
            } else if (source == InstallerFrame.this.nextButton) {
                InstallerFrame.this.navigateNext();
            } else if (source == InstallerFrame.this.quitButton) {
                InstallerFrame.this.exit();
            }
        }
    }
}

