/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.util.List;
import java.util.Properties;
import net.n3.nanoxml.XMLElement;

public class AndCondition
extends Condition {
    protected Condition leftoperand;
    protected Condition rightoperand;

    public AndCondition() {
    }

    public AndCondition(Condition operand1, Condition operand2) {
        this.leftoperand = operand1;
        this.rightoperand = operand2;
    }

    public boolean isTrue(Properties variables) {
        return this.leftoperand.isTrue(variables) && this.rightoperand.isTrue(variables);
    }

    public void readFromXML(XMLElement xmlcondition) {
        try {
            if (xmlcondition.getChildrenCount() != 2) {
                Debug.log("and-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(1));
        }
        catch (Exception e) {
            Debug.log("missing element in and-condition");
        }
    }

    public boolean isTrue(Properties variables, List selectedpacks) {
        return this.leftoperand.isTrue(variables, selectedpacks) && this.rightoperand.isTrue(variables, selectedpacks);
    }
}

