/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.elevation;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jgpstrackedit.map.elevation.ElevationHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class ElevationParser
implements ContentHandler {
    private ElevationHandler handler;
    private Stack context;
    private StringBuffer buffer;
    private EntityResolver resolver;

    public ElevationParser(ElevationHandler handler, EntityResolver resolver) {
        this.handler = handler;
        this.resolver = resolver;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("result".equals(qname)) {
            this.handler.start_result(attrs);
        } else if ("location".equals(qname)) {
            this.handler.start_location(attrs);
        } else if ("ElevationResponse".equals(qname)) {
            this.handler.start_ElevationResponse(attrs);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("result".equals(qname)) {
            this.handler.end_result();
        } else if ("location".equals(qname)) {
            this.handler.end_location();
        } else if ("ElevationResponse".equals(qname)) {
            this.handler.end_ElevationResponse();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if ("status".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_status(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("elevation".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_elevation(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("lng".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_lng(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("resolution".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_resolution(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("lat".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_lat(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        ElevationParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        ElevationParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, ElevationHandler handler) throws SAXException, ParserConfigurationException, IOException {
        ElevationParser.parse(input, new ElevationParser(handler, null));
    }

    public static void parse(URL url, ElevationHandler handler) throws SAXException, ParserConfigurationException, IOException {
        ElevationParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, ElevationParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        if (recognizer.resolver != null) {
            parser.setEntityResolver(recognizer.resolver);
        }
        parser.parse(input);
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                if (ElevationParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

