/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tilehandler;

import java.util.Comparator;
import java.util.LinkedList;
import jgpstrackedit.map.tilehandler.TileLoadEvent;
import jgpstrackedit.map.tilehandler.TileLoadObserver;
import jgpstrackedit.map.util.TileNumber;

public abstract class AbstractTileCommand
implements Comparator<AbstractTileCommand>,
Comparable<AbstractTileCommand> {
    private TileNumber tileNumber;
    private int priority = 0;
    private LinkedList<TileLoadObserver> observers = new LinkedList();

    public void addTileLoadObserver(TileLoadObserver tileLoadObserver) {
        this.observers.add(tileLoadObserver);
    }

    public void addTileLoadObserver(LinkedList<TileLoadObserver> tileLoadObservers) {
        this.observers.addAll(tileLoadObservers);
    }

    public void removeTileLoadObserver(TileLoadObserver tileLoadObserver) {
        this.observers.remove(tileLoadObserver);
    }

    public void notifyTileLoadObservers(TileLoadEvent tileLoadEvent) {
        for (TileLoadObserver observer : this.observers) {
            observer.tileLoaded(tileLoadEvent);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public TileNumber getTileNumber() {
        return this.tileNumber;
    }

    public void setTileNumber(TileNumber tileNumber) {
        this.tileNumber = tileNumber;
    }

    public abstract void doAction();

    @Override
    public int compare(AbstractTileCommand o1, AbstractTileCommand o2) {
        if (o1.getPriority() < o2.getPriority()) {
            return -1;
        }
        if (o1.getPriority() > o2.getPriority()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(AbstractTileCommand arg0) {
        return this.compare(this, arg0);
    }
}

