/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tilehandler;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jgpstrackedit.config.SystemConfig;
import jgpstrackedit.map.tilehandler.AbstractDiskTileCommand;
import jgpstrackedit.map.util.ImageConverter;

public class TileSaveCommand
extends AbstractDiskTileCommand {
    private Image tileImage;

    public Image getTileImage() {
        return this.tileImage;
    }

    public void setTileImage(Image tileImage) {
        this.tileImage = tileImage;
    }

    @Override
    public void doAction() {
        String dirPath = String.valueOf(this.getBaseDirectory()) + SystemConfig.dirSeparator() + this.getTileNumber().getZoom() + SystemConfig.dirSeparator() + this.getTileNumber().getX();
        File dir = new File(dirPath);
        dir.mkdirs();
        String fileName = String.valueOf(dirPath) + SystemConfig.dirSeparator() + this.getTileNumber().getY() + ".png";
        BufferedImage bufferedImage = ImageConverter.toBufferedImage(this.getTileImage());
        if (bufferedImage != null) {
            File file = new File(fileName);
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("File not saved due to null-image: " + fileName);
        }
    }
}

