/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.TreeMap;
import jgpstrackedit.data.Point;
import jgpstrackedit.map.util.MapExtract;
import jgpstrackedit.util.Parser;

public class MapExtractManager {
    private static TreeMap<String, MapExtract> mapExtracts = new TreeMap();

    public static void add(MapExtract mapExtract) {
        mapExtracts.put(mapExtract.getName(), mapExtract);
    }

    public static void remove(MapExtract mapExtract) {
        mapExtracts.remove(mapExtract.getName());
    }

    public static void remove(String mapExtract) {
        mapExtracts.remove(mapExtract);
    }

    public static void add(String mapExtractAsString) {
        String[] token = mapExtractAsString.split(";");
        mapExtracts.put(token[0], new MapExtract(token[0], Parser.parseInt(token[1]), token[2], token[3]));
    }

    public static void add(String mapExtractName, int zoomLevel, Point upperLeftBoundary) {
        mapExtracts.put(mapExtractName, new MapExtract(mapExtractName, zoomLevel, upperLeftBoundary));
    }

    public static String[] mapExtractNames() {
        String[] ret = new String[mapExtracts.size()];
        int index = 0;
        for (String name : mapExtracts.keySet()) {
            ret[index++] = name;
        }
        return ret;
    }

    public static void load() {
        MapExtractManager.add("AE;7;49.237552;27.139010");
        MapExtractManager.add("AT;7;8.862796;49.395033");
        MapExtractManager.add("AR;4;-96.495602;-21.968955");
        MapExtractManager.add("AU;4;95.962405;-5.976619");
        MapExtractManager.add("BD;6;81.669192;28.598060");
        MapExtractManager.add("BE;7;-0.381642;52.363617");
        MapExtractManager.add("BR;4;-92.403684;12.560015");
        MapExtractManager.add("BY;6;17.860599;56.865856");
        MapExtractManager.add("CA;3;-166.292233;78.379433");
        MapExtractManager.add("CH;7;3.523441;48.433225");
        MapExtractManager.add("CL;3;-142.023434;7.261640");
        MapExtractManager.add("CN;4;66.398196;53.298711");
        MapExtractManager.add("CZ;7;11.201238;51.376000");
        MapExtractManager.add("CO;5;-91.826901;14.484714");
        MapExtractManager.add("DE;6;-0.156979;54.229910");
        MapExtractManager.add("DK;6;-0.058102;58.400616");
        MapExtractManager.add("DZ;5;-15.878415;37.494440");
        MapExtractManager.add("EG;6;22.079349;31.499091");
        MapExtractManager.add("ES;6;-11.648679;44.006606");
        MapExtractManager.add("ET;5;21.705814;20.313302");
        MapExtractManager.add("FR;6;-8.402219;50.376040");
        MapExtractManager.add("GR;6;15.987987;42.255370");
        MapExtractManager.add("HK;10;113.585849;22.723315");
        MapExtractManager.add("HU;7;14.905276;49.006630");
        MapExtractManager.add("ID;4;84.657474;17.181997");
        MapExtractManager.add("IL;7;31.263919;33.755657");
        MapExtractManager.add("IN;4;39.976077;37.771677");
        MapExtractManager.add("IQ;6;36.075931;37.869297");
        MapExtractManager.add("IT;5;-4.952512;48.363064");
        MapExtractManager.add("KN;6;28.649173;5.612303");
        MapExtractManager.add("KR;6;118.616214;41.639995");
        MapExtractManager.add("MA;6;-15.647702;36.519263");
        MapExtractManager.add("MD;7;24.364505;48.759764");
        MapExtractManager.add("MK;8;19.272342;42.621561");
        MapExtractManager.add("MY;5;85.294681;18.115917");
        MapExtractManager.add("NG;6;-1.700558;14.586205");
        MapExtractManager.add("NL;7;0.815311;53.915456");
        MapExtractManager.add("PH;5;102.752445;22.619391");
        MapExtractManager.add("PK;5;51.105228;39.800635");
        MapExtractManager.add("PL;6;9.368167;55.496627");
        MapExtractManager.add("PT;6;-15.625729;43.905667");
        MapExtractManager.add("QA;8;49.034305;26.499549");
        MapExtractManager.add("RO;6;15.355716;49.546769");
        MapExtractManager.add("RS;7;15.520999;46.179937");
        MapExtractManager.add("RU;3;25.682864;75.414347");
        MapExtractManager.add("SE;4;-20.536618;71.989395");
        MapExtractManager.add("SI;8;12.740970;46.997823");
        MapExtractManager.add("SK;7;13.944530;50.358697");
        MapExtractManager.add("TH;5;84.086185;22.393078");
        MapExtractManager.add("TN;6;-0.003171;38.264011");
        MapExtractManager.add("TR;6;25.628421;43.000566");
        MapExtractManager.add("UA;5;13.202396;55.794431");
        MapExtractManager.add("UG;7;28.294864;4.217504");
        MapExtractManager.add("UK;5;-23.513913;62.052838");
        MapExtractManager.add("US;4;-131.602902;54.540020");
        MapExtractManager.add("VN;5;86.261478;26.920061");
        MapExtractManager.add("LAST_MAP_EXTRACT;7;8.862796;49.395033");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream("MapExtracts.dat")));
            String mapExtractAsString = in.readLine();
            while (mapExtractAsString != null) {
                MapExtractManager.add(mapExtractAsString);
                mapExtractAsString = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            System.out.println("MapExtractManager: save");
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream("MapExtracts.dat"))));
            for (MapExtract mapExtract : mapExtracts.values()) {
                out.println(String.valueOf(mapExtract.getName()) + ";" + mapExtract.getZoomLevel() + ";" + mapExtract.getUpperLeftBoundary().getLongitudeAsString() + ";" + mapExtract.getUpperLeftBoundary().getLatitudeAsString());
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static MapExtract get(String selectedMapExtractName) {
        return mapExtracts.get(selectedMapExtractName);
    }

    public static boolean contains(String mapExtractName) {
        return mapExtracts.containsKey(mapExtractName);
    }
}

