/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.config.ConfigurationObserver;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.TrackObserver;
import jgpstrackedit.data.util.TourPlaner;
import jgpstrackedit.international.International;
import jgpstrackedit.util.Parser;

public class TrackDataPanel
extends JPanel
implements TrackObserver,
ConfigurationObserver {
    private Track track = null;
    private JTextField textFieldName;
    private JTextField textFieldLength;
    private JTextField textFieldUp;
    private JTextField textFieldDown;
    private JTextField textFieldPoints;
    private JTextField textFieldDensity;
    private JTextField textFieldDuration;
    private JTextField textFieldDrivingTime;
    private JTextField textFieldMinElevation;
    private JTextField textFieldMaxElevation;

    public Track getTrack() {
        return this.track;
    }

    public void setTrack(Track track) {
        if (this.track != null) {
            this.track.removeTrackObserver(this);
        }
        this.track = track;
        track.addTrackObserver(this);
        this.initializeFields();
    }

    protected void initializeFields() {
        if (this.track != null) {
            DecimalFormat df = new DecimalFormat("#####0.000");
            double length = this.track.getLength();
            int points = this.track.getNumberPoints();
            TourPlaner tourPlaner = new TourPlaner(this.track);
            this.textFieldName.setText(this.track.getName());
            this.textFieldLength.setText(df.format(length));
            this.textFieldUp.setText(df.format(this.track.getUpAltitudeDifference()));
            this.textFieldDown.setText(df.format(this.track.getDownAltitudeDifference()));
            this.textFieldMinElevation.setText(df.format(this.track.getLowestElevation()));
            this.textFieldMaxElevation.setText(df.format(this.track.getHighestElevation()));
            this.textFieldPoints.setText("" + points);
            this.textFieldDensity.setText(df.format((double)points / length));
            this.textFieldDuration.setText(Parser.formatTimeHHMM(tourPlaner.tourTime()));
            this.textFieldDrivingTime.setText(Parser.formatTimeHHMM(tourPlaner.drivingTime()));
        }
    }

    public TrackDataPanel() {
        Configuration.addConfigurationObserver(this);
        this.setPreferredSize(new Dimension(504, 137));
        this.setLayout(null);
        JLabel lblName = new JLabel(String.valueOf(International.getText("dlg_tdp.Name")) + ":");
        lblName.setBounds(10, 11, 46, 14);
        this.add(lblName);
        this.textFieldName = new JTextField();
        this.textFieldName.setEditable(false);
        this.textFieldName.setBounds(66, 8, 428, 20);
        this.add(this.textFieldName);
        this.textFieldName.setColumns(10);
        JLabel lblLength = new JLabel(String.valueOf(International.getText("dlg_tdp.Length")) + ":");
        lblLength.setBounds(10, 36, 57, 14);
        this.add(lblLength);
        this.textFieldLength = new JTextField();
        this.textFieldLength.setEditable(false);
        this.textFieldLength.setBounds(66, 33, 86, 20);
        this.add(this.textFieldLength);
        this.textFieldLength.setColumns(10);
        JLabel lblKm = new JLabel("km");
        lblKm.setBounds(162, 36, 26, 14);
        this.add(lblKm);
        JLabel lblUp = new JLabel(String.valueOf(International.getText("dlg_tdp.Up")) + ":");
        lblUp.setBounds(191, 36, 29, 14);
        this.add(lblUp);
        this.textFieldUp = new JTextField();
        this.textFieldUp.setEditable(false);
        this.textFieldUp.setBounds(220, 33, 86, 20);
        this.add(this.textFieldUp);
        this.textFieldUp.setColumns(10);
        JLabel lblDown = new JLabel(String.valueOf(International.getText("dlg_tdp.Down")) + ":");
        lblDown.setBounds(316, 36, 36, 14);
        this.add(lblDown);
        this.textFieldDown = new JTextField();
        this.textFieldDown.setEditable(false);
        this.textFieldDown.setBounds(362, 33, 86, 20);
        this.add(this.textFieldDown);
        this.textFieldDown.setColumns(10);
        JLabel lblM = new JLabel("m");
        lblM.setBounds(459, 36, 26, 14);
        this.add(lblM);
        JLabel lblPoints = new JLabel(String.valueOf(International.getText("dlg_tdp.Points")) + ":");
        lblPoints.setBounds(10, 86, 46, 14);
        this.add(lblPoints);
        this.textFieldPoints = new JTextField();
        this.textFieldPoints.setEditable(false);
        this.textFieldPoints.setBounds(66, 83, 86, 20);
        this.add(this.textFieldPoints);
        this.textFieldPoints.setColumns(10);
        JLabel lblDensity = new JLabel(String.valueOf(International.getText("dlg_tdp.Density")) + ":");
        lblDensity.setBounds(162, 86, 58, 14);
        this.add(lblDensity);
        this.textFieldDensity = new JTextField();
        this.textFieldDensity.setEditable(false);
        this.textFieldDensity.setBounds(220, 83, 86, 20);
        this.add(this.textFieldDensity);
        this.textFieldDensity.setColumns(10);
        JLabel lblPointsKm = new JLabel(International.getText("dlg_tdp.points_km"));
        lblPointsKm.setBounds(316, 86, 86, 14);
        this.add(lblPointsKm);
        JLabel lblDuration = new JLabel(String.valueOf(International.getText("dlg_tdp.Duration")) + ":");
        lblDuration.setBounds(10, 111, 57, 14);
        this.add(lblDuration);
        this.textFieldDuration = new JTextField();
        this.textFieldDuration.setEditable(false);
        this.textFieldDuration.setBounds(66, 108, 86, 20);
        this.add(this.textFieldDuration);
        this.textFieldDuration.setColumns(10);
        JLabel lblHhmm = new JLabel("hh:mm");
        lblHhmm.setBounds(162, 111, 57, 14);
        this.add(lblHhmm);
        JLabel lblDrivingTime = new JLabel(String.valueOf(International.getText("dlg_tdp.Driving_time")) + ":");
        lblDrivingTime.setBounds(220, 111, 106, 14);
        this.add(lblDrivingTime);
        this.textFieldDrivingTime = new JTextField();
        this.textFieldDrivingTime.setEditable(false);
        this.textFieldDrivingTime.setBounds(362, 108, 86, 20);
        this.add(this.textFieldDrivingTime);
        this.textFieldDrivingTime.setColumns(10);
        JLabel lblHhmm_1 = new JLabel("hh:mm");
        lblHhmm_1.setBounds(458, 111, 46, 14);
        this.add(lblHhmm_1);
        JLabel lblElevation = new JLabel(String.valueOf(International.getText("dlg_tdp.Elevation")) + ":");
        lblElevation.setBounds(10, 61, 71, 14);
        this.add(lblElevation);
        this.textFieldMinElevation = new JTextField();
        this.textFieldMinElevation.setEditable(false);
        this.textFieldMinElevation.setBounds(220, 58, 86, 20);
        this.add(this.textFieldMinElevation);
        this.textFieldMinElevation.setColumns(10);
        this.textFieldMaxElevation = new JTextField();
        this.textFieldMaxElevation.setEditable(false);
        this.textFieldMaxElevation.setBounds(362, 58, 86, 20);
        this.add(this.textFieldMaxElevation);
        this.textFieldMaxElevation.setColumns(10);
        JLabel lblMax = new JLabel(String.valueOf(International.getText("dlg_tdp.max")) + ":");
        lblMax.setBounds(316, 61, 46, 14);
        this.add(lblMax);
        JLabel lblMin = new JLabel(String.valueOf(International.getText("dlg_tdp.min")) + ":");
        lblMin.setBounds(162, 61, 48, 14);
        this.add(lblMin);
    }

    @Override
    public void trackModified(Track track) {
        if (this.track.equals(track)) {
            this.initializeFields();
        }
    }

    @Override
    public void configurationChanged() {
        this.initializeFields();
    }
}

